/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.persons;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbsenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPresenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbility;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbsence;
import com.radiantminds.roadmap.common.rest.entities.people.RestPerson;
import com.radiantminds.roadmap.common.rest.entities.people.RestPresence;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.persons.PersonServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/persons")
@Component
public class PersonService
extends BaseOperationsService<IPerson, RestPerson> {
    private final PersonServiceHandler handler;

    @Autowired
    public PersonService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPersonPersistence personPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioAbilityPersistence abilityPersistence, PortfolioAbsenceIntervalPersistence absenceIntervalPersistence, PortfolioPresenceIntervalPersistence presenceIntervalPersistence) {
        super(RestPerson.class, personPersistence, handlerFactory);
        this.handler = handlerFactory.createProxy(PersonServiceHandler.class, new PersonServiceHandler.Impl(activeObjectsUtilities, abilityPersistence, absenceIntervalPersistence, presenceIntervalPersistence, workItemPersistence), personPersistence);
    }

    @Override
    protected RestPerson transform(IPerson entity, boolean includeReplanningData) {
        return new RestPerson(entity);
    }

    @Override
    protected Response update(RestPerson source, IPerson target, boolean allowNull) {
        if (allowNull || source.getDetails() != null) {
            target.setDetails(source.getDetails());
        }
        if (allowNull || source.getTitle() != null) {
            target.setTitle(source.getTitle());
        }
        return null;
    }

    @PUT
    @Path(value="{personId}/abilities/stage/{stageId}")
    public Response setStageAbility(@PathParam(value="personId") String personId, @PathParam(value="stageId") String stageId, @QueryParam(value="version") Long expectedEntityVersion, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestAbility ability) throws Exception {
        return this.handler.setStageAbility(EntityContext.from(personId, expectedEntityVersion, expectedPlanVersion, clientId), stageId, ability.getAbilityValue());
    }

    @PUT
    @Path(value="{personId}/abilities/skill/{skillId}")
    public Response setSkillAbility(@PathParam(value="personId") String personId, @PathParam(value="skillId") String skillId, @QueryParam(value="version") Long expectedEntityVersion, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestAbility ability) throws Exception {
        return this.handler.setSkillAbility(EntityContext.from(personId, expectedEntityVersion, expectedPlanVersion, clientId), skillId, ability.getAbilityValue());
    }

    @GET
    @Path(value="{id}/presences")
    public Response getAllPresenceIntervals(@PathParam(value="id") String personId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllPresences(EntityContext.from(personId, expectedPlanVersion));
    }

    @POST
    @Path(value="{id}/presences")
    public Response addPresenceIntervalToPerson(@PathParam(value="id") String personId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestPresence newInterval) throws Exception {
        return this.handler.addPresenceToPerson(EntityContext.from(personId, expectedPlanVersion, clientId), newInterval);
    }

    @PUT
    @Path(value="{id}/presences/rank")
    public Response rankPresences(@PathParam(value="id") String personId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankPresence(EntityContext.from(personId, expectedPlanVersion, clientId), rank);
    }

    @GET
    @Path(value="{id}/absences")
    public Response getAllAbsenceIntervals(@PathParam(value="id") String personId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllAbsences(EntityContext.from(personId, expectedPlanVersion));
    }

    @POST
    @Path(value="{id}/absences")
    public Response addAbsenceIntervalToPerson(@PathParam(value="id") String personId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestAbsence newInterval) throws Exception {
        return this.handler.addAbsenceToPerson(EntityContext.from(personId, expectedPlanVersion, clientId), newInterval);
    }

    @PUT
    @Path(value="{id}/absences/rank")
    public Response rankAbsences(@PathParam(value="id") String personId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankAbsences(EntityContext.from(personId, expectedPlanVersion, clientId), rank);
    }
}

