/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.plans;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.generator.template.PlanTemplate;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanImporter;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginUserAccess;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.plans.RestCreatePlanRequest;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlan;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsServiceHandler;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public interface PlanServiceHandler {
    @AuthorizedPluginUserAccess
    public Response postPlan(RestCreatePlanRequest var1, boolean var2) throws Exception;

    @AuthorizedPluginReadAccess
    public Response collectionGet(boolean var1) throws Exception;

    @AuthorizedPlanReadAccess
    public Response entryGet(EntityContext<IPlan> var1, boolean var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.Off, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response entryDelete(EntityContext<IPlan> var1) throws Exception;

    public static class Impl
    extends BaseOperationsServiceHandler.Impl<IPlan, RestPlan>
    implements PlanServiceHandler {
        private final UserExtension userExtension;
        private final AnalyticsExtension analyticsExtension;
        private final PlanPermissions planPermissionHandler;
        private final PluginPermissions pluginPermissionHandler;
        private final PortfolioPlanPersistence planPersistence;
        private final Scheduling scheduling;
        private final PlanImporter planImporter;

        public Impl(UserExtension userExtension, AnalyticsExtension analyticsExtension, PlanPermissions planPermissionHandler, PluginPermissions pluginPermissionHandler, PortfolioPlanPersistence planPersistence, Scheduling scheduling, PlanImporter planImporter) {
            super(planPersistence);
            this.userExtension = userExtension;
            this.analyticsExtension = analyticsExtension;
            this.planPermissionHandler = planPermissionHandler;
            this.pluginPermissionHandler = pluginPermissionHandler;
            this.planPersistence = planPersistence;
            this.scheduling = scheduling;
            this.planImporter = planImporter;
        }

        @Override
        public Response postPlan(RestCreatePlanRequest planRequest, boolean triggerScheduling) throws Exception {
            this.analyticsExtension.publishPlanCreatedEvent(planRequest.getTemplate(), planRequest.getAccessMode(), planRequest.getPlanningUnit());
            String planningUnit = planRequest.getPlanningUnit();
            if (planningUnit != null && !PlanningUnit.check(planningUnit)) {
                throw new Exception("Illegal planning unit: " + planningUnit);
            }
            String userId = this.userExtension != null ? this.userExtension.getActiveUserData().getUserID() : null;
            PlanTemplate template = PlanTemplate.parse(planRequest.getTemplate());
            IPlan entity = this.planImporter.createPlanFromResource(planRequest.getTitle(), planRequest.getDescription(), planningUnit, planRequest.getAccessMode(), userId, template);
            if (triggerScheduling) {
                this.scheduling.triggerSolution(entity.getId());
            }
            return ResponseBuilder.ok(new ModificationResult(entity));
        }

        @Override
        public Response collectionGet(boolean includeReplanning) throws Exception {
            List<IPlan> plans = this.planPersistence.listPlansWithCustomQuery(includeReplanning);
            Map<String, Collection<PlanPermission>> planPermissions = this.planPermissionHandler.getPlanPermissions(plans);
            List<RestPlan> restPlans = ToRest.transferList(RestPlan.class, IPlan.class, plans);
            ArrayList visiblePlans = Lists.newArrayList();
            boolean isPluginEditor = this.pluginPermissionHandler.checkOr(PluginPermission.FullEditor, PluginPermission.NonPublishingEditor);
            for (RestPlan restPlan : restPlans) {
                Collection<PlanPermission> planPermission = planPermissions.get(restPlan.getId());
                if (planPermission.isEmpty()) continue;
                if (isPluginEditor && planPermission.contains((Object)PlanPermission.Editor)) {
                    restPlan.setAccessMode("editor");
                } else {
                    restPlan.setAccessMode("viewer");
                }
                visiblePlans.add(restPlan);
            }
            return ResponseBuilder.okForArray(Iterables.toArray((Iterable)visiblePlans, RestPlan.class));
        }

        @Override
        public Response entryGet(EntityContext<IPlan> entityContext, boolean includeReplanning) throws Exception {
            IPlan plan = this.planPersistence.getPlanWithCustomQuery(entityContext.getEntityId(), includeReplanning);
            return entityContext.ok(plan);
        }

        @Override
        public Response entryDelete(EntityContext<IPlan> entityContext) throws Exception {
            return super.entryDelete(entityContext);
        }
    }
}

