/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams.teams;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.StreamToTeamSql;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.services.streams.teams.StreamTeamAssignmentRequest;
import com.radiantminds.roadmap.common.rest.services.streams.teams.TeamsAvailableValidator;
import java.sql.SQLException;
import javax.ws.rs.core.Response;

public interface StreamTeamAssignmentServiceHandler {
    @AuthorizedPlanUserAccess
    public Response handleRequest(EntityContext<IStream> var1, StreamTeamAssignmentRequest var2) throws Exception;

    public static class Impl
    implements StreamTeamAssignmentServiceHandler {
        private static final Log LOGGER = Log.with(StreamTeamAssignmentServiceHandler.class);
        private final TeamsAvailableValidator validator;
        private final StreamToTeamSql streamToTeamSql;

        public Impl(PersistenceIndex persistenceIndex, ActiveObjectsUtilities activeObjectsUtilities, PortfolioTeamPersistence teamPersistence) {
            this(persistenceIndex, activeObjectsUtilities, new TeamsAvailableValidator(teamPersistence));
        }

        Impl(PersistenceIndex persistenceIndex, ActiveObjectsUtilities activeObjectsUtilities, TeamsAvailableValidator teamsAvailableValidator) {
            this.validator = teamsAvailableValidator;
            this.streamToTeamSql = new StreamToTeamSql(persistenceIndex, activeObjectsUtilities);
        }

        @Override
        public Response handleRequest(EntityContext<IStream> entityContext, StreamTeamAssignmentRequest request) throws Exception {
            LOGGER.debug("handle request: %s", request);
            Optional<String> errorResponse = this.validator.tryGetErrorResponse(request);
            if (errorResponse.isPresent()) {
                LOGGER.debug("return error response: %s", errorResponse.get());
                return ResponseBuilder.badRequest(RestMessaging.error((String)errorResponse.get()));
            }
            this.executeOperation(entityContext.getEntityId(), request);
            return entityContext.okForEntityUpdate();
        }

        protected void executeOperation(String streamId, StreamTeamAssignmentRequest request) throws SQLException {
            this.streamToTeamSql.clearTeamAssignmentsForStream(streamId);
            this.streamToTeamSql.setTeamAssignment(streamId, request.getTeamIds());
        }
    }
}

