/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.system.entities;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueData;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestStatusInfo;
import com.radiantminds.roadmap.common.rest.services.system.entities.RestImportVersionEntry;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="item")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestImportResultEntry {
    public static Function<IIssueData, RestImportResultEntry> TRANSFORMATION = new Function<IIssueData, RestImportResultEntry>(){

        public RestImportResultEntry apply(@Nullable IIssueData input) {
            return new RestImportResultEntry(input);
        }
    };
    @XmlElement
    private String key;
    @XmlElement
    private String title;
    @XmlElement
    private String description;
    @XmlElement
    private Long projectId;
    @XmlElement
    private Long estimate;
    @XmlElement
    private Double storyPoints;
    @XmlElement
    private RestStatusInfo statusInfo;
    @XmlElement
    private Long issueTypeId;
    @XmlElement
    private String issueTypeName;
    @XmlElement
    private String issueTypeIconUrl;
    @XmlElement
    private String epicLink;
    @XmlElement
    private List<RestImportVersionEntry> fixVersions;

    @Deprecated
    private RestImportResultEntry() {
    }

    public RestImportResultEntry(IIssueData issueData) {
        this.key = issueData.getKey();
        this.title = issueData.getTitle();
        this.description = issueData.getDescription();
        this.projectId = issueData.getProjectId();
        this.estimate = issueData.getEstimate();
        this.storyPoints = issueData.getStoryPoints();
        this.statusInfo = RestStatusInfo.from(issueData.getStatusData());
        this.issueTypeId = issueData.getIssueTypeId();
        this.issueTypeName = issueData.getIssueTypeName();
        this.issueTypeIconUrl = issueData.getIssueTypeIconURL();
        this.epicLink = (String)issueData.getEpicLink().orNull();
        this.fixVersions = Lists.newArrayList((Iterable)Iterables.transform(issueData.getFixVersions(), RestImportVersionEntry.TRANSFORMATION));
    }
}

