/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.status;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.entities.workitems.status.RestBulkWorkItemStatus;
import com.radiantminds.roadmap.common.rest.entities.workitems.status.RestWorkItemStatus;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.status.StatusOperationFactory;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public interface WorkItemStatusServiceHandler {
    @AuthorizedPlanUserAccess
    public Response setStatus(EntityContext<IWorkItem> var1, RestWorkItemStatus var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setReplanningStatus(EntityContext<IWorkItem> var1, RestWorkItemStatus var2) throws Exception;

    @AuthorizedPlanUserAccess
    public Response setStatusInBulk(BulkEntityContext<IWorkItem> var1, RestBulkWorkItemStatus var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setReplanningStatusInBulk(BulkEntityContext<IWorkItem> var1, RestBulkWorkItemStatus var2) throws Exception;

    public static class Impl
    implements WorkItemStatusServiceHandler {
        private final StatusOperationFactory operationFactory;
        private final OperationExecutor operationExecutor;

        public Impl(OperationExecutor operationExecutor, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioStreamPersistence streamPersistence, PortfolioTeamPersistence teamPersistence, PortfolioPlanPersistence planPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
            this.operationExecutor = operationExecutor;
            this.operationFactory = new StatusOperationFactory(workItemPersistence, estimatePersistence, streamPersistence, teamPersistence, planPersistence, portfolioToJiraSyncExtension);
        }

        @Override
        public Response setStatus(EntityContext<IWorkItem> entityContext, RestWorkItemStatus status) throws Exception {
            return this.operationExecutor.execute(entityContext, this.operationFactory.create(DataMode.Default, Impl.createStatusMap(entityContext, status)));
        }

        @Override
        public Response setReplanningStatus(EntityContext<IWorkItem> entityContext, RestWorkItemStatus status) throws Exception {
            return this.operationExecutor.execute(entityContext, this.operationFactory.create(DataMode.Replanning, Impl.createStatusMap(entityContext, status)));
        }

        @Override
        public Response setStatusInBulk(BulkEntityContext<IWorkItem> entityContext, RestBulkWorkItemStatus status) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Default, status.getStatusMap()));
        }

        @Override
        public Response setReplanningStatusInBulk(BulkEntityContext<IWorkItem> entityContext, RestBulkWorkItemStatus status) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Replanning, status.getStatusMap()));
        }

        private static Map<String, RestWorkItemStatus> createStatusMap(EntityContext<?> entityContext, RestWorkItemStatus status) {
            HashMap retVal = Maps.newHashMap();
            retVal.put(entityContext.getEntityId(), status);
            return retVal;
        }
    }
}

