/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.scheduling.CalculationMode;
import com.radiantminds.roadmap.common.scheduling.CalculationProcess;
import com.radiantminds.roadmap.common.scheduling.CalculationProcessProvider;
import com.radiantminds.roadmap.common.scheduling.CalculationVitalityHandler;
import com.radiantminds.roadmap.common.scheduling.LocalCalculationProcess;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;

public class PluginCalculationProcessProvider
implements CalculationProcessProvider<FullContentSchedulingPlan> {
    private final FeatureExtension features;
    private final MetaDataUtils metaDataUtils;
    private final ActiveObjectsUtilities activeObjectsUtilities;

    public PluginCalculationProcessProvider(FeatureExtension features, MetaDataUtils metaDataUtils, ActiveObjectsUtilities activeObjectsUtilities) {
        this.features = features;
        this.metaDataUtils = metaDataUtils;
        this.activeObjectsUtilities = activeObjectsUtilities;
    }

    @Override
    public CalculationProcess create(FullContentSchedulingPlan schedulingPlan, String calculationId, CalculationVitalityHandler vitalityHandler) {
        return new LocalCalculationProcess(schedulingPlan, calculationId, this.features.getPlanningHorizonInDays(), vitalityHandler);
    }

    @Override
    public CalculationMode getMode() {
        return CalculationMode.Local;
    }
}

