/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.servlet;

import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanExportCache;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanXml;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanExportServlet
extends HttpServlet {
    private final PlanPermissions planPermissionHandler;

    @Autowired
    public PlanExportServlet(PlanPermissions planPermissionHandler) {
        this.planPermissionHandler = planPermissionHandler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String key = req.getParameter("key");
        if (key != null) {
            try {
                PlanXml plan = PlanExportCache.get(key);
                if (plan == null) {
                    resp.setStatus(404);
                    return;
                }
                if (this.planPermissionHandler.check(plan.getPlanId(), PlanPermission.Viewer, PlanPermission.Editor).isDenied()) {
                    resp.setStatus(401);
                    resp.getWriter().write("Permission denied");
                    return;
                }
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + plan.getPlanName() + ".xml\"");
                resp.setContentType("application/octet-stream");
                resp.setCharacterEncoding("UTF-8");
                resp.getWriter().write(plan.getPlanXml());
            }
            catch (Exception ex) {
                resp.setStatus(500);
                resp.getWriter().write(ex.getMessage());
            }
        } else {
            resp.setStatus(404);
        }
    }
}

