/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.info;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.rm.common.bridges.api.Version;
import com.radiantminds.roadmap.common.extensions.info.InfoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraInfoExtension
implements InfoExtension {
    private final ApplicationProperties properties;
    private boolean jiraVersionParsed = false;
    private Version jiraVersion = null;
    public static final Version REQUIRED_VERSION_FOR_FLAT_STYLES = new Version("6.4");

    @Autowired
    public JiraInfoExtension(ApplicationProperties properties) {
        this.properties = properties;
    }

    public Version getVersion() {
        if (this.jiraVersionParsed) {
            return this.jiraVersion;
        }
        this.jiraVersionParsed = true;
        String jiraVersionString = this.properties.getString("jira.version");
        this.jiraVersion = new Version(jiraVersionString);
        return this.jiraVersion;
    }

    @Override
    public boolean meetsVersionRequirements(Version version) {
        Version jira = this.getVersion();
        return jira != null && jira.compareTo(version) >= 0;
    }
}

