/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data;

import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.workitems.EstimateRatioData;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.common.extensions.workitems.WorkData;
import java.util.Map;

class JiraExtensionData
implements WorkItemExtensionLinkData {
    private final Map<String, ProgressData> progressMap;
    private final Map<String, ProgressData> fullProgressMap;
    private final Map<String, StatusData> statusMap;
    private final Map<String, WorkData> timeDataMap;
    private final Map<String, EstimateRatioData> estimateRatioDataMap;
    private final Map<String, String> jpoToJiraKeyMap;

    JiraExtensionData(Map<String, StatusData> statusMap, Map<String, ProgressData> progressMap, Map<String, ProgressData> fullProgressMap, Map<String, WorkData> timeDataMap, Map<String, EstimateRatioData> estimateRatioDataMap, Map<String, String> jpoToJiraKeyMap) {
        this.progressMap = progressMap;
        this.statusMap = statusMap;
        this.timeDataMap = timeDataMap;
        this.fullProgressMap = fullProgressMap;
        this.estimateRatioDataMap = estimateRatioDataMap;
        this.jpoToJiraKeyMap = jpoToJiraKeyMap;
    }

    @Override
    public StatusData getStatusData(String linkId) {
        return this.statusMap.get(this.getCorrectLinkKey(linkId));
    }

    @Override
    public ProgressData getFullProgress(String linkId) {
        return this.fullProgressMap.get(this.getCorrectLinkKey(linkId));
    }

    @Override
    public ProgressData getProgress(String linkId) {
        return this.progressMap.get(this.getCorrectLinkKey(linkId));
    }

    @Override
    public WorkData getTimeData(String linkId) {
        return this.timeDataMap.get(this.getCorrectLinkKey(linkId));
    }

    @Override
    public EstimateRatioData getEstimatedRationData(String linkId) {
        return this.estimateRatioDataMap.get(this.getCorrectLinkKey(linkId));
    }

    private String getCorrectLinkKey(String linkId) {
        if (this.jpoToJiraKeyMap.containsKey(linkId)) {
            return this.jpoToJiraKeyMap.get(linkId);
        }
        return linkId;
    }
}

