/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.search;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.query.Query;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.jira.search.SearchResults;
import com.atlassian.rm.common.bridges.jira.search.SearchServiceBridge;
import com.atlassian.rm.common.bridges.jira.search.SearchServiceBridgeProxy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.IssueSearchResult;
import com.radiantminds.roadmap.common.extensions.workitems.search.IIssueSearchResult;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.IJiraIssueRequest;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.IJiraIssueRequestHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.IssueData;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class JiraIssueRequestHandler
implements IJiraIssueRequestHandler {
    private static final Log LOGGER = Log.with(JiraIssueRequestHandler.class);
    private final SearchServiceBridgeProxy searchServiceBridgeProxy;
    private final IssueManager issueManager;
    private final JiraAgileAccessor agileAccessor;
    private final CustomFields customFields;

    JiraIssueRequestHandler(SearchServiceBridgeProxy searchServiceBridgeProxy, IssueManager issueManager, JiraAgileAccessor agileAccessor, CustomFields customFields) {
        this.searchServiceBridgeProxy = searchServiceBridgeProxy;
        this.issueManager = issueManager;
        this.agileAccessor = agileAccessor;
        this.customFields = customFields;
    }

    @Override
    public IIssueSearchResult getResult(IJiraIssueRequest request) throws SearchException {
        long totalIssueCount;
        List<Issue> issues;
        LOGGER.debug("get issue data for request: %s", request);
        ApplicationUser user = request.getUser();
        Query query = this.getQuery(request, user);
        String baseUrl = request.getBaseUrl();
        IIssueRequest.EstimationMethod estimationMethod = request.getEstimationMethod();
        CustomField currentEpicLinkField = this.customFields.tryGetEpicLinkField();
        CustomField storyPointField = null;
        boolean jiraAgileUnavailable = false;
        boolean storyPointsFieldUnavailable = false;
        if (estimationMethod == IIssueRequest.EstimationMethod.STORY_POINTS) {
            if (this.agileAccessor.isUsable()) {
                try {
                    storyPointField = this.customFields.getStoryPointsCustomField();
                }
                catch (AgileNotAvailableException e) {
                    jiraAgileUnavailable = true;
                }
                catch (AgileCustomFieldNotAvailableException e) {
                    storyPointsFieldUnavailable = true;
                }
            } else {
                jiraAgileUnavailable = true;
            }
        }
        ArrayList issueList = Lists.newArrayList();
        int requestSize = Ints.saturatedCast((long)request.getResultsLimit());
        int start = 0;
        HashSet ignoredKeys = Sets.newHashSet(request.getExcludedLinks());
        do {
            SearchResults<Issue> searchResult = ((SearchServiceBridge)this.searchServiceBridgeProxy.get()).search(user, query, PagerFilter.newPageAlignedFilter((int)start, (int)requestSize));
            start += requestSize;
            totalIssueCount = searchResult.getTotal();
            issues = searchResult.getResults();
            for (Issue issue : issues) {
                String key = issue.getKey();
                if (ignoredKeys.contains(key)) continue;
                IssueData issueData = IssueData.createFromIssue(issue, estimationMethod, baseUrl, currentEpicLinkField, storyPointField);
                if (request.isEpicFetchEnabled() && issueData.getEpicLink().isPresent() && !ignoredKeys.contains(issueData.getEpicLink().get())) {
                    String epicLink = (String)issueData.getEpicLink().get();
                    MutableIssue epicIssue = this.issueManager.getIssueObject(epicLink);
                    IssueData epicData = IssueData.createFromIssue((Issue)epicIssue, estimationMethod, baseUrl, currentEpicLinkField, storyPointField);
                    issueList.add(epicData);
                    if ((long)issueList.size() == request.getResultsLimit()) {
                        IssueSearchResult result = new IssueSearchResult(issueList, totalIssueCount, jiraAgileUnavailable, storyPointsFieldUnavailable);
                        LOGGER.debug("result of limited search: %s", result);
                        return result;
                    }
                    ignoredKeys.add(epicData.getKey());
                }
                issueList.add(issueData);
                if ((long)issueList.size() == request.getResultsLimit()) {
                    IssueSearchResult result = new IssueSearchResult(issueList, totalIssueCount, jiraAgileUnavailable, storyPointsFieldUnavailable);
                    LOGGER.debug("result of limited search: %s", result);
                    return result;
                }
                ignoredKeys.add(key);
            }
        } while (issues.size() >= requestSize);
        IssueSearchResult result = new IssueSearchResult(issueList, totalIssueCount, jiraAgileUnavailable, storyPointsFieldUnavailable);
        LOGGER.debug("result of completed search: %s", result);
        return result;
    }

    private Query getQuery(IJiraIssueRequest request, ApplicationUser user) {
        SearchService.ParseResult parseResult = ((SearchServiceBridge)this.searchServiceBridgeProxy.get()).parseQuery(user, request.getQuery());
        Query query = parseResult.getQuery();
        return query;
    }

    public static final IJiraIssueRequestHandler createInstance(SearchServiceBridgeProxy searchServiceBridgeProxy, IssueManager issueManager, JiraAgileAccessor agileAccessor, CustomFields customFields) {
        JiraIssueRequestHandler instance = new JiraIssueRequestHandler(searchServiceBridgeProxy, issueManager, agileAccessor, customFields);
        return instance;
    }
}

