/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues.sync.tasks;

import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import java.util.Set;

public class TitleSyncTask
implements SyncTask {
    private static final Log LOGGER = Log.with(TitleSyncTask.class);
    private final CustomField epicTitleField;
    private final Set<String> epicIssueTypes;
    private String title;

    public TitleSyncTask(String title, CustomField epicTitleField, Set<String> epicIssueTypes) {
        this.epicTitleField = epicTitleField;
        this.epicIssueTypes = epicIssueTypes;
        if (title != null && title.length() > 255) {
            title = title.substring(0, 255);
        }
        this.title = title;
    }

    public TitleSyncTask(String title) {
        this(title, null, null);
    }

    @Override
    public boolean apply(MutableIssue issue, IssueInputParameters issueInputParameters) {
        boolean modified = false;
        if (!Objects.equal((Object)issue.getSummary(), (Object)this.title)) {
            issueInputParameters.setSummary(this.title);
            modified = true;
        }
        if (this.epicTitleField != null && this.epicIssueTypes.contains(issue.getIssueTypeObject().getId()) && !Objects.equal((Object)issue.getCustomFieldValue(this.epicTitleField), (Object)this.title)) {
            issueInputParameters.addCustomFieldValue(this.epicTitleField.getIdAsLong(), new String[]{this.title});
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean apply(IWorkItem workItem) {
        if (Objects.equal((Object)this.title, (Object)workItem.getTitle())) {
            return false;
        }
        workItem.setTitle(this.title);
        return true;
    }

    public static TitleSyncTask createPortfolioToJiraTask(String baseTitle, Optional<IStage> stage, CustomField epicTitleField, Set<String> epicIssueTypes) {
        String title = TitleSyncTask.getTitle(baseTitle, stage);
        return new TitleSyncTask(title, epicTitleField, epicIssueTypes);
    }

    private static String getTitle(String baseTitle, Optional<IStage> stage) {
        if (baseTitle == null || baseTitle.trim().equals("")) {
            baseTitle = "No Summary";
        }
        if (stage.isPresent()) {
            return String.format("%s (%s)", baseTitle, ((IStage)stage.get()).getTitle());
        }
        return baseTitle;
    }
}

