/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.backlog;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedUnstructuredEpicConfiguration;

public class RandomizedUnstructuredEpicConfiguration
implements IRandomizedUnstructuredEpicConfiguration {
    private final int minOverallEstimation;
    private final int maxOverallEstimation;

    protected RandomizedUnstructuredEpicConfiguration(int minOverallEstimation, int maxOverallEstimation) {
        this.minOverallEstimation = minOverallEstimation;
        this.maxOverallEstimation = maxOverallEstimation;
    }

    @Override
    public int getMinOverallEstimation() {
        return this.minOverallEstimation;
    }

    @Override
    public int getMaxOverallEstimation() {
        return this.maxOverallEstimation;
    }

    public static class Builder {
        private int minOverallEstimation = 50;
        private int maxOverallEstimation = 200;

        public Builder withOverallEstimationBetween(int minOverallEstimation, int maxOverallEstimation) {
            Preconditions.checkArgument((minOverallEstimation <= maxOverallEstimation ? 1 : 0) != 0);
            this.minOverallEstimation = minOverallEstimation;
            this.maxOverallEstimation = maxOverallEstimation;
            return this;
        }

        public RandomizedUnstructuredEpicConfiguration build() {
            return new RandomizedUnstructuredEpicConfiguration(this.minOverallEstimation, this.maxOverallEstimation);
        }
    }
}

