/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissionCheckResult;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import java.util.List;
import javax.ws.rs.core.Response;

class EntityContextPreparationResult {
    private PlanPermissionCheckResult planPermissionCheckResult;
    private Response directResponse;
    private List<EntityInfo> entityInfos = Lists.newArrayList();
    private final PlanPermissions planPermissionHandler;
    private final PlanPermission[] requiredPermissions;

    static EntityContextPreparationResult create(PlanPermissions planPermissionHandler, PlanPermission[] requiredPermissions, PlanPermissionCheckResult planPermissionCheckResult) {
        EntityContextPreparationResult retVal = new EntityContextPreparationResult(planPermissionHandler, requiredPermissions);
        retVal.planPermissionCheckResult = planPermissionCheckResult;
        return retVal;
    }

    static EntityContextPreparationResult createForBulk(PlanPermissions planPermissionHandler, PlanPermission[] requiredPermissions, PlanPermissionCheckResult planPermissionCheckResult, List<EntityInfo> entityInfos) {
        EntityContextPreparationResult retVal = new EntityContextPreparationResult(planPermissionHandler, requiredPermissions);
        retVal.planPermissionCheckResult = planPermissionCheckResult;
        retVal.entityInfos = entityInfos;
        return retVal;
    }

    static EntityContextPreparationResult createErrorResponse(PlanPermissions planPermissionHandler, PlanPermission[] requiredPermissions, Response directResponse) {
        EntityContextPreparationResult retVal = new EntityContextPreparationResult(planPermissionHandler, requiredPermissions);
        retVal.directResponse = directResponse;
        return retVal;
    }

    private EntityContextPreparationResult(PlanPermissions planPermissionHandler, PlanPermission[] requiredPermissions) {
        this.planPermissionHandler = planPermissionHandler;
        this.requiredPermissions = requiredPermissions;
    }

    public PlanPermissionCheckResult getPlanPermissionCheckResult() {
        return this.planPermissionCheckResult;
    }

    public Optional<Response> getDirectResponse() {
        return Optional.fromNullable((Object)this.directResponse);
    }

    public List<EntityInfo> getEntityInfos() {
        return this.entityInfos;
    }

    public PlanPermissions getPlanPermissionHandler() {
        return this.planPermissionHandler;
    }

    public PlanPermission[] getRequiredPermissions() {
        return this.requiredPermissions;
    }
}

