/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.rm.common.bridges.jira.lucene.JiraLuceneQueryUtilities;
import com.atlassian.rm.common.bridges.jira.lucene.JiraLuceneQueryUtilitiesProxy;
import com.atlassian.rm.common.bridges.lucene.Document;
import com.atlassian.rm.common.bridges.lucene.IndexSearcher;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.IssueInfo;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.IssueHierarchyResult;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.LuceneJiraIssueAccessorIssueWrapper;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.RetrievedJiraIssue;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.status.JiraIssueStatusData;
import com.radiantminds.roadmap.jira.common.components.utils.BaseURL;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.JiraAgileCustomFieldData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LuceneHierarchyResult
implements IssueHierarchyResult {
    private static final String INDEX_KEY_ISSUE_ID = "issue_id";
    private static final String INDEX_KEY_ISSUE_PARENTTASK = "issue_parenttask";
    private static final String INDEX_KEY_PREFIX_CUSTOMFIELD = "customfield_";
    private static final String INDEX_KEY_ISSUE_KEY = "key";
    private static final String INDEX_KEY_ISSUE_TYPE = "type";
    private final Map<String, String> jpoToJiraKeyMap = Maps.newHashMap();
    private final Map<String, Set<String>> parentChildRelationships = Maps.newHashMap();
    private final Map<String, Set<String>> epicStoryRelationships = Maps.newHashMap();
    private final Map<String, LuceneJiraIssueAccessorIssueWrapper> issuesByKey = Maps.newHashMap();
    private final Map<String, IssueInfo> issueInfosByKey = Maps.newHashMap();

    private LuceneHierarchyResult() {
    }

    public static LuceneHierarchyResult extract(IndexSearcher indexSearcher, FieldManager fieldManager, JiraLuceneQueryUtilitiesProxy luceneQueryUtilities, CustomFields customFields, StatusManager statusManager, ApplicationProperties applicationProperties, Set<String> issueKeys) throws IOException {
        LuceneHierarchyResult result = new LuceneHierarchyResult();
        result.init(indexSearcher, fieldManager, luceneQueryUtilities, customFields, statusManager, applicationProperties, issueKeys);
        return result;
    }

    private void init(IndexSearcher indexSearcher, FieldManager fieldManager, JiraLuceneQueryUtilitiesProxy luceneQueryUtilities, CustomFields customFields, StatusManager statusManager, ApplicationProperties applicationProperties, Set<String> issueKeys) throws IOException {
        CustomField epicLinkField;
        HashSet epicIds = Sets.newHashSet();
        HashMap documentsByKey = Maps.newHashMap();
        HashMap statusCache = Maps.newHashMap();
        Optional<JiraAgileCustomFieldData> jiraAgileData = customFields.tryGetJiraAgileData();
        HashSet supportedFields = Sets.newHashSet();
        if (jiraAgileData.isPresent()) {
            supportedFields.add(((JiraAgileCustomFieldData)jiraAgileData.get()).getStoryPointsCustomField());
        }
        String baseUrl = BaseURL.get(applicationProperties);
        Query permissionFilter = ((JiraLuceneQueryUtilities)luceneQueryUtilities.get()).getProjectPermissionQueryForCurrentUser();
        Query query = indexSearcher.getQueryFactory().createDisjunctTermQuery(INDEX_KEY_ISSUE_KEY, issueKeys);
        String epicIssueTypeId = jiraAgileData.isPresent() ? ((JiraAgileCustomFieldData)jiraAgileData.get()).getEpicIssueTypeId() : null;
        for (Integer documentNumber : indexSearcher.search(query, permissionFilter, Integer.MAX_VALUE)) {
            Document document = indexSearcher.getIndexReader().getDocument(documentNumber, Lists.newArrayList((Object[])new String[]{INDEX_KEY_ISSUE_KEY, INDEX_KEY_ISSUE_ID, INDEX_KEY_ISSUE_TYPE}));
            String id = document.getValue(INDEX_KEY_ISSUE_ID);
            String string = document.getValue(INDEX_KEY_ISSUE_KEY);
            String type = document.getValue(INDEX_KEY_ISSUE_TYPE);
            this.jpoToJiraKeyMap.put(string, id);
            if (epicIssueTypeId != null && epicIssueTypeId.equals(type)) {
                epicIds.add(id);
            }
            documentsByKey.put(id, documentNumber);
        }
        CustomField customField = epicLinkField = jiraAgileData.isPresent() ? ((JiraAgileCustomFieldData)jiraAgileData.get()).getEpicLinkField() : null;
        if (epicLinkField != null && epicIds.size() > 0) {
            Long epicLinkFieldId = epicLinkField.getIdAsLong();
            String epicParentField = INDEX_KEY_PREFIX_CUSTOMFIELD + epicLinkFieldId;
            Query epicStoryQuery = indexSearcher.getQueryFactory().createDisjunctTermQuery(epicParentField, documentsByKey.keySet());
            for (Integer documentNumber : indexSearcher.search(epicStoryQuery, permissionFilter, Integer.MAX_VALUE)) {
                Document document = indexSearcher.getIndexReader().getDocument(documentNumber, Lists.newArrayList((Object[])new String[]{epicParentField, INDEX_KEY_ISSUE_ID}));
                String id = document.getValue(INDEX_KEY_ISSUE_ID);
                String epicParent = document.getValue(epicParentField);
                documentsByKey.put(id, documentNumber);
                this.storeParentChildRelation(id, epicParent);
                this.storeEpicStoryRelation(id, epicParent);
            }
        }
        Query subTaskQuery = indexSearcher.getQueryFactory().createDisjunctTermQuery(INDEX_KEY_ISSUE_PARENTTASK, documentsByKey.keySet());
        for (Integer documentNumber : indexSearcher.search(subTaskQuery, permissionFilter, Integer.MAX_VALUE)) {
            Document document = indexSearcher.getIndexReader().getDocument(documentNumber, Lists.newArrayList((Object[])new String[]{INDEX_KEY_ISSUE_PARENTTASK, INDEX_KEY_ISSUE_ID}));
            String id = document.getValue(INDEX_KEY_ISSUE_ID);
            String parent = document.getValue(INDEX_KEY_ISSUE_PARENTTASK);
            documentsByKey.put(id, documentNumber);
            this.storeParentChildRelation(id, parent);
        }
        ArrayList fieldsForSelection = Lists.newArrayList((Object[])new String[]{"status", "timespent", "timeoriginalestimate", "timeestimate"});
        for (CustomField customField2 : supportedFields) {
            fieldsForSelection.add(INDEX_KEY_PREFIX_CUSTOMFIELD + customField2.getIdAsLong());
        }
        for (Map.Entry entry : documentsByKey.entrySet()) {
            Document document = indexSearcher.getIndexReader().getDocument((Integer)entry.getValue(), fieldsForSelection);
            Long timeSpent = this.getSingleValueFromField(fieldManager, "timespent", document);
            Long originalEstimate = this.getSingleValueFromField(fieldManager, "timeoriginalestimate", document);
            Long remainingEstimate = this.getSingleValueFromField(fieldManager, "timeestimate", document);
            String status = document.getValue("status");
            if (!statusCache.containsKey(status)) {
                statusCache.put(status, statusManager.getStatus(status));
            }
            StatusData statusData = JiraIssueStatusData.createInstance((Status)statusCache.get(status), baseUrl);
            IssueInfo issueInfo = new IssueInfo(timeSpent, statusData, originalEstimate, remainingEstimate, null);
            this.issueInfosByKey.put((String)entry.getKey(), issueInfo);
            LuceneJiraIssueAccessorIssueWrapper issueWrapper = new LuceneJiraIssueAccessorIssueWrapper(supportedFields);
            for (CustomField field : supportedFields) {
                String strStoryPoints = document.getValue(INDEX_KEY_PREFIX_CUSTOMFIELD + field.getIdAsLong());
                if (Strings.isNullOrEmpty((String)strStoryPoints)) continue;
                issueWrapper.storeCustomFieldValue(field, Double.parseDouble(strStoryPoints));
            }
            this.issuesByKey.put((String)entry.getKey(), issueWrapper);
        }
    }

    private void storeParentChildRelation(String issue, String parent) {
        if (!this.parentChildRelationships.containsKey(parent)) {
            this.parentChildRelationships.put(parent, Sets.newHashSet());
        }
        this.parentChildRelationships.get(parent).add(issue);
    }

    private void storeEpicStoryRelation(String issue, String parent) {
        if (!this.epicStoryRelationships.containsKey(parent)) {
            this.epicStoryRelationships.put(parent, Sets.newHashSet());
        }
        this.epicStoryRelationships.get(parent).add(issue);
    }

    private Long getSingleValueFromField(FieldManager fieldManager, String fieldName, Document document) {
        LuceneFieldSorter sorter = fieldManager.getNavigableField(fieldName).getSorter();
        return (Long)sorter.getValueFromLuceneField(document.getValue(sorter.getDocumentConstant()));
    }

    @Override
    public Map<String, RetrievedJiraIssue> getIssuesByKey() {
        return Collections.unmodifiableMap(this.issuesByKey);
    }

    @Override
    public Map<String, IssueInfo> getIssueInfoByKey() {
        return this.issueInfosByKey;
    }

    @Override
    public Map<String, Set<String>> getSubIssueRelationships() {
        return this.parentChildRelationships;
    }

    @Override
    public Map<String, String> getJpoJiraKeyMap() {
        return this.jpoToJiraKeyMap;
    }

    @Override
    public Map<String, Set<String>> getUnestimatedCountRelevant() {
        return this.epicStoryRelationships;
    }
}

