/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.calculation.NoOpCalculationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.ApacheLpAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.WeightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.WeightedAssignmentLpProblemCreator;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;

class SearchCancellationTest {
    private final WeightedAssignmentLpProblemCreator weightedAssignmentLpProblemCreator;

    SearchCancellationTest(WeightedAssignmentLpProblemCreator weightedAssignmentLpProblemCreator) {
        this.weightedAssignmentLpProblemCreator = weightedAssignmentLpProblemCreator;
    }

    SearchCancellationTest() {
        this(new WeightedAssignmentLpProblemCreator());
    }

    public boolean isToCancel(final AssignmentCandidate candidate) throws InterruptedException {
        if (!candidate.areLimitedResourcesGone()) {
            return false;
        }
        Optional<ImmutableNonEmptyPositivePrimitivesMap<IResourceType>> limitedDemands = candidate.getDemandsOfLimitedResources();
        if (!limitedDemands.isPresent()) {
            return false;
        }
        PositivePrimitivesMap<AssignmentResource> limitedAvailabilities = RmCollectionUtils.filterKeys(candidate.getAggregatedAvailabilities(), new Predicate<AssignmentResource>(){

            public boolean apply(AssignmentResource input) {
                return candidate.getLimitedAvailableResources().contains(input);
            }
        });
        Optional<WeightedAssignmentLpProblem> problem = this.weightedAssignmentLpProblemCreator.createFeasibilityProblem(limitedAvailabilities, (PositivePrimitivesMap)limitedDemands.get());
        if (!problem.isPresent()) {
            return true;
        }
        ApacheLpAssignmentSolver solver = new ApacheLpAssignmentSolver(new NoOpCalculationState());
        return !solver.trySolve((WeightedAssignmentLpProblem)problem.get()).isPresent();
    }
}

