/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;

public class SQLServerGeometryWriter {
    private static final int POINT = 1;
    private static final int LINE_STRING = 2;
    private static final int POLYGON = 3;
    private static final int MULTI_POINT = 4;
    private static final int MULTI_LINESTRING = 5;
    private static final int MULTI_POLYGON = 6;
    private static final int GEOMETRY_COLLECTION = 7;
    private List<Point> points = Lists.newArrayList();
    private List<Figure> figures = Lists.newArrayList();
    private List<Shape> shapes = Lists.newArrayList();

    private int calculateCapacity(Geometry geometry) {
        int numPoints = this.points.size();
        int prefixSize = 6;
        if (geometry instanceof Point) {
            int capacity = prefixSize + 16 * numPoints;
            if (geometry.is3D()) {
                capacity += 8 * numPoints;
            }
            if (geometry.isMeasured()) {
                capacity += 8 * numPoints;
            }
            return capacity;
        }
        int pointSize = 16 + (geometry.is3D() ? 8 : 0) + (geometry.isMeasured() ? 8 : 0);
        int size = prefixSize + 12;
        size += numPoints * pointSize;
        size += this.figures.size() * 5;
        return size += this.shapes.size() * 9;
    }

    public byte[] write(Geometry geometry) throws IOException {
        this.visit(geometry, -1);
        int bytes = this.calculateCapacity(geometry);
        boolean singlePoint = geometry instanceof Point;
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(geometry.getSRID());
        buffer.put((byte)1);
        buffer.put((byte)((geometry.is3D() ? 1 : 0) + (geometry.isMeasured() ? 2 : 0) + 4 + (singlePoint ? 8 : 0) + 0));
        if (!singlePoint) {
            buffer.putInt(this.points.size());
        }
        for (Point point : this.points) {
            buffer.putDouble(point.getX());
            buffer.putDouble(point.getY());
        }
        if (geometry.is3D()) {
            for (Point point : this.points) {
                buffer.putDouble(point.getZ());
            }
        }
        if (geometry.isMeasured()) {
            for (Point point : this.points) {
                buffer.putDouble(point.getM());
            }
        }
        if (!singlePoint) {
            buffer.putInt(this.figures.size());
            for (Figure figure : this.figures) {
                buffer.put((byte)figure.attributes);
                buffer.putInt(figure.pointOffset);
            }
            buffer.putInt(this.shapes.size());
            for (Shape shape : this.shapes) {
                buffer.putInt(shape.parentOffset);
                buffer.putInt(shape.figureOffset);
                buffer.put((byte)shape.type);
            }
        }
        return buffer.array();
    }

    private void visit(Geometry geometry, int parent) {
        switch (geometry.getGeometryType()) {
            case POINT: {
                this.visit((Point)geometry, parent);
                break;
            }
            case POLYGON: {
                this.visit((Polygon)geometry, parent);
                break;
            }
            case LINE_STRING: {
                this.visit((LineString)geometry, parent);
                break;
            }
            case MULTI_POINT: {
                this.visit((MultiPoint)geometry, parent);
                break;
            }
            case MULTI_LINE_STRING: {
                this.visit((MultiLineString)geometry, parent);
                break;
            }
            case MULTI_POLYGON: {
                this.visit((MultiPolygon)geometry, parent);
                break;
            }
            case GEOMETRY_COLLECTION: {
                this.visit((GeometryCollection)geometry, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException(geometry.toString());
            }
        }
    }

    public void visit(Point point, int parent) {
        Shape shape = new Shape();
        shape.type = 1;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        Figure figure = new Figure();
        figure.attributes = 1;
        figure.pointOffset = this.points.size();
        this.figures.add(figure);
        this.points.add(point);
    }

    public void visit(LineString lineString, int parent) {
        Shape shape = new Shape();
        shape.type = 2;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        Figure figure = new Figure();
        figure.attributes = 1;
        figure.pointOffset = this.points.size();
        this.figures.add(figure);
        for (Point point : lineString.getPoints()) {
            this.points.add(point);
        }
    }

    public void visit(Polygon polygon, int parent) {
        Shape shape = new Shape();
        shape.type = 3;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        Figure figure = new Figure();
        figure.attributes = 2;
        figure.pointOffset = this.points.size();
        this.figures.add(figure);
        for (Point point : polygon.getExteriorRing().getPoints()) {
            this.points.add(point);
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            figure = new Figure();
            figure.attributes = 0;
            figure.pointOffset = this.points.size();
            this.figures.add(figure);
            for (Point point : polygon.getInteriorRingN(i).getPoints()) {
                this.points.add(point);
            }
        }
    }

    public void visit(MultiPoint collection, int parent) {
        Shape shape = new Shape();
        shape.type = 4;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        parent = this.shapes.size() - 1;
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            this.visit(collection.getGeometryN(i), parent);
        }
    }

    public void visit(MultiLineString collection, int parent) {
        Shape shape = new Shape();
        shape.type = 5;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        parent = this.shapes.size() - 1;
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            this.visit(collection.getGeometryN(i), parent);
        }
    }

    public void visit(MultiPolygon collection, int parent) {
        Shape shape = new Shape();
        shape.type = 6;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        parent = this.shapes.size() - 1;
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            this.visit(collection.getGeometryN(i), parent);
        }
    }

    public void visit(GeometryCollection collection, int parent) {
        Shape shape = new Shape();
        shape.type = 7;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        parent = this.shapes.size() - 1;
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            this.visit(collection.getGeometryN(i), parent);
        }
    }

    public void visit(PolyHedralSurface surface, int parent) {
        Shape shape = new Shape();
        shape.type = -1;
        shape.figureOffset = this.figures.size();
        shape.parentOffset = parent;
        this.shapes.add(shape);
        parent = this.shapes.size() - 1;
        for (int i = 0; i < surface.getNumPatches(); ++i) {
            this.visit(surface.getPatchN(i), parent);
        }
    }

    private static class Shape {
        int parentOffset;
        int figureOffset;
        int type;

        private Shape() {
        }
    }

    private static class Figure {
        int attributes;
        int pointOffset;

        private Figure() {
        }
    }
}

