/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.Estimates;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.StageInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.StoryPointsSyncTask;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.SyncTaskFactory;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.JiraAgileCustomFieldData;
import java.util.Locale;
import java.util.Set;

class StoryPointEstimateSyncTaskFactory
implements SyncTaskFactory {
    private final StageInformation stageInformation;
    private final JiraAgileCustomFieldData customFieldData;
    private final Locale locale;

    public StoryPointEstimateSyncTaskFactory(StageInformation stageInformation, JiraAgileCustomFieldData customFieldData, Locale locale) {
        this.stageInformation = stageInformation;
        this.customFieldData = customFieldData;
        this.locale = locale;
    }

    @Override
    public Optional<SyncTask> createTask(PortfolioToJiraSyncData data, Optional<IStage> stage) {
        if (data.getRemainingEstimates().isPresent()) {
            Optional<Double> remainingEstimatesSum = Estimates.toEstimateSum(data.getRemainingEstimates(), stage, this.stageInformation);
            return Optional.of((Object)new StoryPointsSyncTask((Double)remainingEstimatesSum.get(), this.locale, this.customFieldData.getStoryPointsCustomField(), (Set)MoreObjects.firstNonNull(this.customFieldData.getStoryPointEnabledIssueTypeIds(), (Object)Sets.newHashSet())));
        }
        return Optional.absent();
    }
}

