/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintComparators;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.agile.service.AgileIssueDataServiceBridge;
import com.atlassian.rm.common.bridges.agile.service.AgileIssueDataServiceBridgeProxy;
import com.atlassian.rm.common.bridges.agile.service.AgileServiceOutcomeExceptionFactory;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandlerAction;
import com.atlassian.rm.common.bridges.agile.service.UnsafeBundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprint;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprintManagerBridge;
import com.atlassian.rm.common.bridges.agile.sprints.SprintsTransformer;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessor;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.sprints.AgileSprintManagerBridgeImpl")
@SupportedVersions(all=true)
class AgileSprintManagerBridgeImpl
implements AgileSprintManagerBridge {
    private static final Log LOGGER = Log.with(AgileSprintManagerBridgeImpl.class);
    private static final String SPRINT_MANAGER_COMPONENT_NAME = "sprintManagerImpl";
    private static final String RAPID_VIEW_MANAGER_COMPONENT_NAME = "rapidViewManagerImpl";
    private static final String RAPID_VIEW_QUERY_SERVICE_COMPONENT_NAME = "rapidViewQueryServiceImpl";
    private static final String SPRINT_NOT_FOUND_ERROR_KEY = "gh.sprint.error.not.found";
    private static final String RAPID_VIEW_NOT_FOUND_ERROR_KEY = "gh.rapid.view.error.noview";
    private final SearchRequestManager searchRequestManager;
    private final AgileCustomFieldsServiceBridgeProxy agileCustomFieldServiceBridgeProxy;
    private final AgileIssueDataServiceBridgeProxy agileIssueDataServiceProxy;
    private final BundleServiceAccessor<SprintManager> sprintManagerServiceAccessor;
    private final UnsafeBundleServiceServiceOutcomeHandler sprintManagerServiceOutcomeHandler;
    private final UnsafeBundleServiceServiceOutcomeHandler rapidViewManagerServiceOutcomeHandler;
    private final UnsafeBundleServiceServiceOutcomeHandler rapidViewQueryServiceOutcomeHandler;

    @Autowired
    public AgileSprintManagerBridgeImpl(BundleServiceAccessorProvider bundleServiceAccessorProvider, SearchRequestManager searchRequestManager, AgileCustomFieldsServiceBridgeProxy agileCustomFieldServiceBridgeProxy, AgileIssueDataServiceBridgeProxy agileIssueDataServiceProxy) {
        this.searchRequestManager = searchRequestManager;
        this.agileCustomFieldServiceBridgeProxy = agileCustomFieldServiceBridgeProxy;
        this.agileIssueDataServiceProxy = agileIssueDataServiceProxy;
        this.sprintManagerServiceAccessor = bundleServiceAccessorProvider.createUnsafeServiceAccessor("com.pyxis.greenhopper.jira", SPRINT_MANAGER_COMPONENT_NAME);
        this.sprintManagerServiceOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", SPRINT_MANAGER_COMPONENT_NAME);
        this.rapidViewManagerServiceOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", RAPID_VIEW_MANAGER_COMPONENT_NAME);
        this.rapidViewQueryServiceOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", RAPID_VIEW_QUERY_SERVICE_COMPONENT_NAME);
    }

    @Override
    public Optional<AgileSprint> getSprintWithoutPermissionCheck(final long sprintId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.sprintManagerServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<SprintManager, ServiceOutcome, Sprint, Optional<AgileSprint>>(){

            @Override
            public ServiceOutcome getServiceOutcome(SprintManager sprintManager) {
                return sprintManager.getSprint(sprintId);
            }

            @Override
            public Optional<AgileSprint> getResult(Sprint sprint) {
                return Optional.of((Object)SprintsTransformer.sprintToAgileSprint(sprint));
            }

            @Override
            public Optional<AgileSprint> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, AgileSprintManagerBridgeImpl.SPRINT_NOT_FOUND_ERROR_KEY)) {
                    return Optional.absent();
                }
                return (Optional)super.handleErrors(serviceOutcome);
            }
        });
    }

    @Override
    public List<AgileSprint> tryFindSprintsWithoutPermissionCheck(ApplicationUser user, final long boardId, final Set<AgileSprint.State> states) throws AgileServiceOutcomeException, AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        LOGGER.debug("sprint query for board: %d", boardId);
        Optional<?> rapidView = this.getRapidViewWithoutPermissionCheck(boardId);
        if (!rapidView.isPresent()) {
            LOGGER.debug("no view found for board: %d", boardId);
            return Lists.newArrayList();
        }
        if (!((RapidView)rapidView.get()).isSprintSupportEnabled()) {
            LOGGER.debug("sprints not supported", new Object[0]);
            return Lists.newArrayList();
        }
        final Collection<Sprint> additionalSprints = this.getAdditionalSprintsForRapidView(user, rapidView.get(), states);
        return this.sprintManagerServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<SprintManager, ServiceOutcome, Collection<Sprint>, List<AgileSprint>>(){

            @Override
            public ServiceOutcome getServiceOutcome(SprintManager sprintManager) {
                return sprintManager.getSprintsForView(Long.valueOf(boardId), EnumSet.copyOf(SprintsTransformer.transformSprintStates(states)));
            }

            @Override
            public List<AgileSprint> getResult(Collection<Sprint> sprints) {
                HashSet combinedSprints = Sets.newHashSet(sprints);
                combinedSprints.addAll(additionalSprints);
                ArrayList sortedSprints = Lists.newArrayList((Iterable)combinedSprints);
                sortedSprints.sort(SprintComparators.SPRINT_NATURAL_COMPARATOR);
                return SprintsTransformer.transformSprints(sortedSprints);
            }
        });
    }

    protected Optional<?> getRapidViewWithoutPermissionCheck(final long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewManagerServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewManager, ServiceOutcome, RapidView, Optional<RapidView>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewManager rapidViewManager) {
                return rapidViewManager.get(Long.valueOf(boardId));
            }

            @Override
            public Optional<RapidView> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, AgileSprintManagerBridgeImpl.RAPID_VIEW_NOT_FOUND_ERROR_KEY)) {
                    return Optional.absent();
                }
                throw AgileServiceOutcomeExceptionFactory.createException(serviceOutcome.getErrors());
            }

            @Override
            public Optional<RapidView> getResult(RapidView rapidView) {
                return Optional.of((Object)rapidView);
            }
        });
    }

    protected Collection<Sprint> getAdditionalSprintsForRapidView(ApplicationUser user, Object rapidViewObject, final Set<AgileSprint.State> states) throws AgileNotAvailableException, AgileServiceOutcomeException, AgileCustomFieldNotAvailableException {
        Query query = this.getMappedRapidViewQuery(user, rapidViewObject);
        LOGGER.debug("found query %s for board.", query.getQueryString());
        List<Sprint> additionalSprints = this.getSprintsWithQuery(user, query);
        LOGGER.debug("found %d additional sprints for rapid view before filtering.", additionalSprints.size());
        return Collections2.filter(additionalSprints, (Predicate)new Predicate<Sprint>(){

            public boolean apply(Sprint sprint) {
                return states.contains((Object)SprintsTransformer.transformSprintState(sprint.getState()));
            }
        });
    }

    private Query getMappedRapidViewQuery(ApplicationUser user, Object rapidViewObject) throws AgileServiceOutcomeException, AgileNotAvailableException {
        RapidView rapidView = (RapidView)rapidViewObject;
        Optional<Query> rapidViewQuery = this.getFilterWithoutPermissionCheck(rapidView.getSavedFilterId());
        if (!rapidViewQuery.isPresent()) {
            throw new AgileServiceOutcomeException("Could not get filter for board ID: " + rapidView.getId());
        }
        LOGGER.debug("try to get mapped query for board ID %d", rapidView.getId());
        Clause statusMappingClause = this.getStatusMappingClause(user, rapidView);
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)((Query)rapidViewQuery.get()));
        queryBuilder.where().defaultAnd().addClause(statusMappingClause);
        return queryBuilder.buildQuery();
    }

    private Optional<Query> getFilterWithoutPermissionCheck(long id) {
        Optional searchRequest = Optional.fromNullable((Object)this.searchRequestManager.getSearchRequestById(Long.valueOf(id)));
        if (searchRequest.isPresent()) {
            return Optional.of((Object)((SearchRequest)searchRequest.get()).getQuery());
        }
        return Optional.absent();
    }

    private Clause getStatusMappingClause(final ApplicationUser user, Object rapidViewObject) throws AgileNotAvailableException, AgileServiceOutcomeException {
        final RapidView rapidView = (RapidView)rapidViewObject;
        return this.rapidViewQueryServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewQueryService, ServiceOutcome, Clause, Clause>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewQueryService rapidViewQueryService) {
                return rapidViewQueryService.getStatusMappingClause(user, rapidView);
            }

            @Override
            public Clause getResult(Clause clause) {
                return clause;
            }
        });
    }

    protected List<Sprint> getSprintsWithQuery(ApplicationUser user, Query jql) throws AgileNotAvailableException, AgileCustomFieldNotAvailableException, AgileServiceOutcomeException {
        AgileCustomFieldServiceBridge agileCustomFieldServiceBridge = (AgileCustomFieldServiceBridge)this.agileCustomFieldServiceBridgeProxy.get();
        CustomField sprintCustomField = agileCustomFieldServiceBridge.getCustomFields().getSprintsField();
        try {
            Collection<Sprint> sprintCollection = this.getSprints(((AgileIssueDataServiceBridge)this.agileIssueDataServiceProxy.get()).findSprintIdsOverrideSecurity(user, jql, sprintCustomField));
            ArrayList sprints = Lists.newArrayList(sprintCollection);
            sprints.sort(SprintComparators.SPRINT_BYDATE_COMPARATOR);
            return sprints;
        }
        catch (Exception e) {
            throw new AgileServiceOutcomeException(e.getMessage());
        }
    }

    protected Collection<Sprint> getSprints(final Collection<Long> ids) throws Exception {
        return this.sprintManagerServiceAccessor.perform(new ServiceCallback<SprintManager, Collection<Sprint>>(){

            @Override
            public Collection<Sprint> perform(SprintManager sprintManager) throws Exception {
                return SprintUtils.getSprintsForIds((SprintManager)sprintManager, (Collection)ids);
            }
        });
    }
}

