/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import java.sql.SQLException;
import java.util.List;

public final class OrderByHelper {
    public static final List<List<Integer>> orderRanges = Lists.newArrayList();

    public static void addOrderByClause(AOQueryGenerator generator, List<String> workItemLevels) throws SQLException {
        int i = 1;
        for (List<Integer> orderRange : orderRanges) {
            generator.raw("COALESCE(");
            int j = 1;
            for (final String workItemHierarchy : workItemLevels) {
                generator.raw("(CASE").raw("WHEN").inIntegers(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col(workItemHierarchy, "type");
                    }
                }, orderRange).raw("THEN").col(workItemHierarchy, "sortOrder").raw("ELSE");
                if (j == workItemLevels.size() - 1) {
                    generator.numeric(Integer.MAX_VALUE);
                } else {
                    generator.nullValue();
                }
                generator.raw("END)");
                if (j++ >= workItemLevels.size()) continue;
                generator.raw(",");
            }
            generator.raw(")");
            if (i++ >= orderRanges.size()) continue;
            generator.raw(",");
        }
    }

    static {
        orderRanges.add(Lists.newArrayList((Object[])new Integer[]{WorkItems.Types.INITIATIVE}));
        orderRanges.add(Lists.newArrayList((Object[])new Integer[]{WorkItems.Types.EPIC, WorkItems.Types.STORY}));
    }
}

