/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.DistributedOverbookedActivityAssignmentProblemVariables;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.IndexedOverbookableResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentProblemVariables;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;

public class DefaultOverbookedActivityAssignmentSolution
implements OverbookedActivityAssignmentSolution {
    private final float[][] assignmentMatrix;
    private final float overbooked;

    private DefaultOverbookedActivityAssignmentSolution(float[][] assignmentMatrix, float overbooked) {
        this.assignmentMatrix = assignmentMatrix;
        this.overbooked = overbooked;
    }

    @Override
    public int getResources() {
        return this.assignmentMatrix.length;
    }

    @Override
    public int getSkills() {
        if (this.assignmentMatrix.length == 0) {
            return 0;
        }
        return this.assignmentMatrix[0].length;
    }

    @Override
    public float getLoad(int r, int s) {
        return this.assignmentMatrix[r][s];
    }

    @Override
    public float getOverbookedSum() {
        return this.overbooked;
    }

    static DefaultOverbookedActivityAssignmentSolution create(float[] result, DistributedOverbookedActivityAssignmentProblemVariables variables) {
        float[][] assignments = new float[variables.getResources()][variables.getSkills()];
        for (IndexedOverbookableResourceSkillVariable variable : variables.getWorkVariables()) {
            float[] fArray = assignments[variable.getResource()];
            int n = variable.getSkill();
            fArray[n] = fArray[n] + result[variable.getIndex()];
        }
        float overbookedSum = 0.0f;
        for (int r = 0; r < variables.getResources(); ++r) {
            overbookedSum = (float)((double)overbookedSum + Math.max(0.0, (double)RmUtils.sum(assignments[r]) - variables.getAvailability(r)));
        }
        return new DefaultOverbookedActivityAssignmentSolution(assignments, Math.abs(overbookedSum));
    }

    static DefaultOverbookedActivityAssignmentSolution create(float[] result, float value, OverbookedActivityAssignmentProblemVariables variables) {
        float[][] assignments = new float[variables.getResources()][variables.getSkills()];
        for (IndexedOverbookableResourceSkillVariable variable : variables.getVariables()) {
            float[] fArray = assignments[variable.getResource()];
            int n = variable.getSkill();
            fArray[n] = fArray[n] + result[variable.getIndex()];
        }
        return new DefaultOverbookedActivityAssignmentSolution(assignments, value);
    }
}

