/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues.sync.tasks;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueData;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.extensions.workitems.search.IIssueSearchResult;
import com.radiantminds.roadmap.common.rest.services.system.IssueRequest;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.LinkUtils;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseEstimationSyncTask
implements SyncTask {
    private final PortfolioEstimatePersistence estimatePersistence;
    private final WorkItemExtension workItemExtension;
    private final Optional<Integer> stageId;
    private final IIssueRequest.EstimationMethod estimationMethod;

    BaseEstimationSyncTask(PortfolioEstimatePersistence estimatePersistence, WorkItemExtension workItemExtension, Optional<Integer> stageId, IIssueRequest.EstimationMethod estimationMethod) {
        this.estimatePersistence = estimatePersistence;
        this.workItemExtension = workItemExtension;
        this.stageId = stageId;
        this.estimationMethod = estimationMethod;
    }

    Optional<IEstimate> getCurrentStageEstimate(String workItemId, DataMode dataMode) throws Exception {
        List<IEstimate> allStageEstimates = this.estimatePersistence.getStageEstimates(workItemId, dataMode);
        Optional stageEstimate = Optional.absent();
        for (IEstimate e : allStageEstimates) {
            if (!e.getTargetId().equals(this.stageId.get())) continue;
            stageEstimate = Optional.of((Object)e);
        }
        return stageEstimate;
    }

    boolean hasTotalEstimate(String workItemId, DataMode dataMode) throws Exception {
        return this.estimatePersistence.getTotalEstimate(workItemId, dataMode).isPresent();
    }

    Map<String, IIssueData> getStageDataFromJira(List<IExtensionLink> stageLinks) throws Exception {
        HashMap retVal = Maps.newHashMap();
        for (IExtensionLink link : stageLinks) {
            IIssueSearchResult searchResult;
            Optional<Integer> otherStageId = LinkUtils.getStageIdFromLink(link.getExtensionKey());
            if (!otherStageId.isPresent() || otherStageId.equals(this.stageId) || (searchResult = this.workItemExtension.find(IssueRequest.create(String.format("key = %s", link.getExtensionLink()), this.estimationMethod))).getIssues().isEmpty()) continue;
            retVal.put(String.valueOf(otherStageId.get()), searchResult.getIssues().get(0));
        }
        return retVal;
    }
}

