/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.BridgeManager;
import com.atlassian.rm.common.bridges.api.FeatureAccessor;
import com.atlassian.rm.common.bridges.api.NoBridgeAvailableException;
import com.atlassian.rm.common.bridges.api.Version;
import com.atlassian.rm.common.bridges.api.VersionProxy;
import com.atlassian.rm.common.bridges.jira.JiraVersionAccessor;
import com.google.common.base.Optional;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;

public abstract class JiraVersionAwareSpringProxy<TSpringInterface>
implements VersionProxy<TSpringInterface> {
    private static final Log LOGGER = Log.with(JiraVersionAwareSpringProxy.class);
    private final JiraVersionAccessor versionAccessor;
    private final Class<TSpringInterface> springInterface;
    private final BridgeManager<TSpringInterface> bridgeManager;
    private volatile WeakReference<TSpringInterface> bridgeReference = new WeakReference<Object>(null);

    protected JiraVersionAwareSpringProxy(JiraVersionAccessor jiraVersionAccessor, Class<TSpringInterface> springInterface, List<TSpringInterface> beans) {
        this(jiraVersionAccessor, springInterface, beans, (Optional<FeatureAccessor>)Optional.absent());
    }

    protected JiraVersionAwareSpringProxy(JiraVersionAccessor jiraVersionAccessor, Class<TSpringInterface> springInterface, List<TSpringInterface> beans, Optional<FeatureAccessor> featureAccessor) {
        this.versionAccessor = jiraVersionAccessor;
        this.springInterface = springInterface;
        this.bridgeManager = new BridgeManager<TSpringInterface>(beans, featureAccessor);
    }

    @Override
    public TSpringInterface get() {
        Object bridge = this.bridgeReference.get();
        if (null == bridge) {
            bridge = this.load();
            this.bridgeReference = new WeakReference<TSpringInterface>(bridge);
        }
        return (TSpringInterface)bridge;
    }

    private TSpringInterface load() {
        Version apiVersion = this.versionAccessor.getVersion();
        Optional<TSpringInterface> supportedBridge = this.bridgeManager.getSupportedBridge(apiVersion);
        if (supportedBridge.isPresent()) {
            Object bridge = supportedBridge.get();
            LOGGER.debug(String.format("Bridge implementation %s chosen for API version %s.", bridge.getClass(), apiVersion.toString()), new Object[0]);
            return (TSpringInterface)bridge;
        }
        LOGGER.warn(String.format("No bridge implementation for %s available for API version %s.", this.springInterface.toString(), apiVersion.toString()), new Object[0]);
        throw new NoBridgeAvailableException(apiVersion, this.springInterface);
    }

    protected Collection<TSpringInterface> getAvailableBridges() {
        Version apiVersion = this.versionAccessor.getVersion();
        return this.bridgeManager.getAllVersionCompatibleBridges(apiVersion);
    }
}

