/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.FixedDurationEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.FixedScopeEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeStreamState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class EpisodeStreamState
implements IEpisodeStreamState {
    private static final Log LOGGER = Log.with(EpisodeStreamState.class);
    final Map<String, IEpisodeState> episodeStateMap;

    EpisodeStreamState(Map<String, IEpisodeState> episodeStates) {
        this.episodeStateMap = episodeStates;
    }

    @Override
    public void setFinishedItemWithId(String itemId, int end, String episodeId) {
        IEpisodeState episodeState = this.episodeStateMap.get(episodeId);
        episodeState.setFinishedNewEndTime(itemId, end);
    }

    @Override
    public void setFailForItemIdEpisodeId(String itemId, String episodeId) {
        IEpisodeState episodeState = this.episodeStateMap.get(episodeId);
        episodeState.setFailedForItemNewEndTime(itemId);
    }

    @Override
    public IEpisodeState getEpisodeState(String episodeId) {
        return this.episodeStateMap.get(episodeId);
    }

    static IEpisodeStreamState initialize(IEpisodeStream episodeStream, Set<IProcessingItem> assignedItems) {
        Preconditions.checkNotNull((Object)episodeStream, (Object)"stream must not be null");
        Preconditions.checkNotNull(assignedItems, (Object)"assigned items set must not be null");
        LogUtil.debug(LOGGER, "initialize state for stream: %s", episodeStream);
        List<IEpisode> episodes = episodeStream.getEpisodes();
        Map<String, IEpisodeState> episodeStates = EpisodeStreamState.createStateMap(assignedItems, episodes);
        EpisodeStreamState instance = new EpisodeStreamState(episodeStates);
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    private static Map<String, IEpisodeState> createStateMap(Set<IProcessingItem> assignedItems, List<IEpisode> episodes) {
        HashMap episodeStates = Maps.newHashMap();
        Map<IEpisode, Set<IProcessingItem>> itemPartitions = EpisodeStreamState.partitionItems(episodes, assignedItems);
        for (int i = episodes.size() - 1; i >= 0; --i) {
            IEpisode episode = episodes.get(i);
            if (episode.isFixedScope()) {
                IEpisodeState successorState = (IEpisodeState)episodeStates.get(episodes.get(i + 1).getId());
                IEpisodeState state = FixedScopeEpisodeState.initialize(episode, Sets.newHashSet((Object[])new IEpisodeState[]{successorState}), (Integer)EpisodeStreamState.tryCalculateStart(episode, episodes).orNull(), itemPartitions.get(episode));
                episodeStates.put(episode.getId(), state);
                continue;
            }
            IEpisodeState state = FixedDurationEpisodeState.initialize(episode, (Integer)EpisodeStreamState.tryCalculateStart(episode, episodes).orNull(), itemPartitions.get(episode));
            episodeStates.put(episode.getId(), state);
        }
        return episodeStates;
    }

    private static Map<IEpisode, Set<IProcessingItem>> partitionItems(List<IEpisode> episodes, Set<IProcessingItem> assignedItems) {
        final BiMap<String, IEpisode> idMap = RmIdentifiableUtils.createIdMap(episodes);
        return RmUtils.getPartitions(assignedItems, new Function<IProcessingItem, IEpisode>(){

            public IEpisode apply(IProcessingItem input) {
                return (IEpisode)idMap.get(input.getFixedEpisodeId().orNull());
            }
        });
    }

    private static Optional<Integer> tryCalculateStart(IEpisode episode, List<IEpisode> episodes) {
        Optional<Integer> fixedStart = episode.getFixedStartTime();
        if (fixedStart.isPresent()) {
            return fixedStart;
        }
        int episodeIndex = episodes.indexOf(episode);
        if (episodeIndex == 0) {
            LOGGER.warn("no fixed start for first release - start at plan start", new Object[0]);
            return Optional.of((Object)0);
        }
        IEpisode preceding = episodes.get(episodeIndex - 1);
        Optional<Integer> precedingEnd = preceding.getFixedEndTime();
        if (!precedingEnd.isPresent()) {
            return Optional.absent();
        }
        int startGap = (Integer)episode.getStartGap().or((Object)1);
        int calculatedStart = (Integer)precedingEnd.get() + startGap;
        return Optional.of((Object)Math.max(0, calculatedStart));
    }
}

