/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.BaseFixedSlotLpSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.BaseProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DecisionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DistributeOverbookProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpLogging;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.ApacheUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

class DistributeOverbookProblemLpSolver
extends BaseFixedSlotLpSolver {
    private static final double DEFAULT_EPSILON = 0.001;
    private static final int DEFAULT_ULPS = 10;
    private static final double DEFAULT_CUT_OFF = 1.0E-7;
    private final SimplexSolver simplexSolver = new SimplexSolver(0.001, 10, 1.0E-7);

    DistributeOverbookProblemLpSolver() {
    }

    public float[] solve(DistributeOverbookProblem overbookProblem) {
        OptimizationData[] optData = DistributeOverbookProblemLpSolver.transform(overbookProblem);
        LpLogging.logDebug(optData);
        return RmUtils.toFloatArray(this.simplexSolver.optimize(optData).getPoint());
    }

    private static OptimizationData[] transform(DistributeOverbookProblem problem) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MINIMIZE);
        optData.add(DistributeOverbookProblemLpSolver.createObjectiveFunction(problem));
        optData.add(DistributeOverbookProblemLpSolver.createLinearConstraints(problem));
        optData.add(new NonNegativeConstraint(true));
        return optData.toArray(new OptimizationData[optData.size()]);
    }

    private static OptimizationData createLinearConstraints(DistributeOverbookProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        constraints.addAll(DistributeOverbookProblemLpSolver.createAvailabilityConstraintSet(problem));
        constraints.addAll(DistributeOverbookProblemLpSolver.createStrictOpenSkillConstraintSet(problem));
        constraints.addAll(DistributeOverbookProblemLpSolver.createDistributionConstraints(problem));
        return new LinearConstraintSet(constraints);
    }

    private static List<LinearConstraint> createDistributionConstraints(DistributeOverbookProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        for (Pair<IWorkResource, IWorkResource> resourcePair : problem.getResourcePairs()) {
            double[] coefficients = new double[problem.getVariableCount()];
            Pair<Integer, Integer> distributionPair = problem.getDistributionIndices(resourcePair);
            coefficients[distributionPair.getLeft().intValue()] = 1.0;
            coefficients[distributionPair.getRight().intValue()] = -1.0;
            for (DecisionVariable variable : problem.getUnlimitedDecisionVariables(resourcePair.getLeft().getId())) {
                coefficients[variable.getIndex()] = 1.0;
            }
            for (DecisionVariable variable : problem.getUnlimitedDecisionVariables(resourcePair.getRight().getId())) {
                coefficients[variable.getIndex()] = -1.0;
            }
            constraints.add(new LinearConstraint(coefficients, Relationship.EQ, 0.0));
        }
        return constraints;
    }

    private static List<LinearConstraint> createStrictOpenSkillConstraintSet(BaseProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        for (String item : problem.getAssignmentIds()) {
            Map<IResourceType, Set<DecisionVariable>> typeVariables = problem.getTypeVariablesForAssignmentId(item);
            for (Map.Entry<IResourceType, Set<DecisionVariable>> entry : typeVariables.entrySet()) {
                constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(entry.getValue(), problem.getVariableCount()), Relationship.EQ, (double)problem.getType(item, entry.getKey())));
            }
        }
        return constraints;
    }

    private static OptimizationData createObjectiveFunction(DistributeOverbookProblem problem) {
        double[] coefficients = ApacheUtils.createOneCoefficients(problem.getDistributionIndices(), problem.getVariableCount());
        coefficients = DistributeOverbookProblemLpSolver.setValidWorkCoefficients(problem, coefficients);
        LinearObjectiveFunction objective = new LinearObjectiveFunction(coefficients, 0.0);
        return objective;
    }

    private static double[] setValidWorkCoefficients(DistributeOverbookProblem problem, double[] coefficients) {
        double validWorkCoefficient = DistributeOverbookProblemLpSolver.calculateValidWorkCoefficient(problem.getPairCount());
        for (DecisionVariable variable : problem.getLimitedVariables()) {
            coefficients[variable.getIndex()] = -validWorkCoefficient;
        }
        return coefficients;
    }

    private static double calculateValidWorkCoefficient(int pairCount) {
        return pairCount + 1;
    }
}

