/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.AOEntities;
import com.radiantminds.roadmap.common.data.persistence.ao.port.DefaultKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IAnonymisationProvider;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.port.MethodXmlConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.port.TranslationException;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlAnonymise;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlForeignKeyRelation;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlName;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlPrimaryKeyRelation;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.XmlExportablePersistence;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.java.ao.OneToMany;
import net.java.ao.OneToOne;
import net.java.ao.RawEntity;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.Ignore;

class AOEntityTransformationUtil {
    private final ActiveObjectsUtilities activeObjectsUtilities;

    public AOEntityTransformationUtil(ActiveObjectsUtilities activeObjectsUtilities) {
        this.activeObjectsUtilities = activeObjectsUtilities;
    }

    public String getXmlNameForTable(Class<?> aoClazz) {
        return this.getXmlNameForRow(aoClazz) + "Collection";
    }

    public Class<?> getTableForXmlName(String tagName) {
        for (Class<? extends RawEntity> clazz : AOEntities.getEntityTypes()) {
            String xmlName = this.getXmlNameForTable(clazz);
            if (!xmlName.equals(tagName)) continue;
            return clazz;
        }
        return null;
    }

    public String getXmlNameForRow(Class<?> aoClazz) {
        if (aoClazz.isAnnotationPresent(XmlName.class)) {
            return aoClazz.getAnnotation(XmlName.class).value();
        }
        return aoClazz.getSimpleName();
    }

    private static IKeyResolver getForeignKeyResolver(XmlExportablePersistence persistence, Method method) {
        if (method.isAnnotationPresent(XmlForeignKeyRelation.class)) {
            XmlForeignKeyRelation relation = method.getAnnotation(XmlForeignKeyRelation.class);
            if (!"".equals(relation.dependsOn())) {
                return persistence.getForeignKeyResolver(method.getName());
            }
            if (relation.value() == Void.TYPE) {
                return new DefaultKeyResolver(method.getReturnType(), relation.prefix());
            }
            return new DefaultKeyResolver(relation.value(), relation.prefix());
        }
        if (method.isAnnotationPresent(XmlPrimaryKeyRelation.class)) {
            return new DefaultKeyResolver(persistence.getDbInterfaceClass(), new String[]{""});
        }
        return null;
    }

    public static Map<String, Method> getColumnRelevantMethods(Class<?> aoClazz) {
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (Method method : aoClazz.getMethods()) {
            String methodName;
            if (method.isAnnotationPresent(XmlName.class)) {
                methodName = method.getAnnotation(XmlName.class).value();
            } else {
                methodName = method.getName();
                if (methodName.startsWith("get")) {
                    methodName = methodName.substring(3).toLowerCase();
                } else {
                    if (!methodName.startsWith("is")) continue;
                    methodName = methodName.substring(2).toLowerCase();
                }
            }
            if (method.isAnnotationPresent(Ignore.class) || method.isAnnotationPresent(OneToMany.class) || method.isAnnotationPresent(OneToOne.class)) continue;
            retVal.put(methodName, method);
        }
        return retVal;
    }

    public Map<String, MethodXmlConfiguration> getTagNameToXmlConfiguration(Class<?> aoClazz, XmlExportablePersistenceIndex index) throws TranslationException {
        for (XmlExportablePersistence p : index.getPersistenceBeans()) {
            if (p.getDbInterfaceClass() != aoClazz) continue;
            Map<String, MethodXmlConfiguration> methodNameKeyMap = this.getColumnNameToXmlConfiguration(p);
            HashMap retVal = Maps.newHashMap();
            for (MethodXmlConfiguration config : methodNameKeyMap.values()) {
                retVal.put(config.getName(), config);
            }
            return retVal;
        }
        throw new TranslationException("Unknown AO class '" + aoClazz.getName() + "'.");
    }

    public Map<String, MethodXmlConfiguration> getColumnNameToXmlConfiguration(XmlExportablePersistence persistence) throws TranslationException {
        FieldNameConverter converter = this.getFieldNameConverter();
        HashMap retVal = Maps.newHashMap();
        for (Map.Entry<String, Method> entry : AOEntityTransformationUtil.getColumnRelevantMethods(persistence.getDbInterfaceClass()).entrySet()) {
            XmlForeignKeyRelation relation;
            String methodName = entry.getKey();
            String polyTypeMethodName = methodName + "type";
            Method method = entry.getValue();
            String dbMethodName = converter.getName(method);
            String dbPolyTypeName = converter.getPolyTypeName(method);
            IKeyResolver resolver = AOEntityTransformationUtil.getForeignKeyResolver(persistence, method);
            String dependsOn = null;
            if (method.isAnnotationPresent(XmlForeignKeyRelation.class) && !"".equals((relation = method.getAnnotation(XmlForeignKeyRelation.class)).dependsOn())) {
                dependsOn = relation.dependsOn().toLowerCase();
            }
            IAnonymisationProvider anonymisationProvider = null;
            if (method.isAnnotationPresent(XmlAnonymise.class)) {
                XmlAnonymise anonymise = method.getAnnotation(XmlAnonymise.class);
                Class<? extends IAnonymisationProvider> anonymisationProviderType = anonymise.value();
                try {
                    anonymisationProvider = anonymisationProviderType.newInstance();
                }
                catch (InstantiationException e) {
                    throw new TranslationException("Failed to instantiate anonymisation provider '" + anonymisationProviderType.getName() + "'. Probably misconfigured");
                }
                catch (IllegalAccessException e) {
                    throw new TranslationException("Failed to instantiate anonymisation provider '" + anonymisationProviderType.getName() + "'. Probably misconfigured");
                }
            }
            retVal.put(dbPolyTypeName.toLowerCase(), new MethodXmlConfiguration(polyTypeMethodName, dbPolyTypeName.toLowerCase(), entry.getValue().getName(), null, null, false, false, true, String.class, anonymisationProvider));
            retVal.put(dbMethodName.toLowerCase(), new MethodXmlConfiguration(methodName, dbMethodName.toLowerCase(), entry.getValue().getName(), resolver, dependsOn, method.isAnnotationPresent(XmlPrimaryKeyRelation.class), method.isAnnotationPresent(XmlForeignKeyRelation.class), false, method.getReturnType(), anonymisationProvider));
        }
        return retVal;
    }

    private FieldNameConverter getFieldNameConverter() {
        return this.activeObjectsUtilities.getAccessor().getEntityManager().getFieldNameConverter();
    }
}

