/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.workitems.WorkItemServiceHandler;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/workitems")
@Component
public class WorkItemService
extends BaseOperationsService<IWorkItem, RestWorkItem> {
    private final WorkItemServiceHandler handler;
    private final PortfolioToJiraSyncExtension portfolioToJiraSyncExtension;

    @Autowired
    public WorkItemService(SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        super(RestWorkItem.class, workItemPersistence, handlerFactory);
        this.handler = handlerFactory.createProxy(WorkItemServiceHandler.class, new WorkItemServiceHandler.Impl(workItemPersistence), workItemPersistence);
        this.portfolioToJiraSyncExtension = portfolioToJiraSyncExtension;
    }

    @Override
    protected RestWorkItem transform(IWorkItem entity, boolean includeReplanningData) {
        throw new RuntimeException("Construction of single work items via AO Entity not allowed.");
    }

    @Override
    protected Response update(RestWorkItem source, IWorkItem target, boolean allowNull) {
        Number val;
        this.updateCommons(source, target, allowNull);
        if (source.getEarliestStart() != null || allowNull) {
            val = source.getEarliestStart();
            if (val == null || (Long)val == -1L) {
                val = null;
            }
            target.setEarliestStart((Long)val);
        }
        if (source.getTargetStart().isPresent() || allowNull) {
            val = (Long)source.getTargetStart().orNull();
            if (val == null || (Long)val == -1L) {
                val = null;
            }
            target.setTargetStart((Long)val);
        }
        if (source.getTargetEnd().isPresent() || allowNull) {
            val = (Long)source.getTargetEnd().orNull();
            if (val == null || (Long)val == -1L) {
                val = null;
            }
            target.setTargetEnd((Long)val);
        }
        if (source.getBusinessValue().isPresent() || allowNull) {
            val = (Double)source.getBusinessValue().orNull();
            if (val == null || (Double)val == Double.MAX_VALUE) {
                val = null;
            }
            target.setBusinessValue((Double)val);
        }
        return null;
    }

    @Override
    @GET
    @Path(value="/{id}")
    public Response entryGet(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="replanning") Boolean replanning) throws Exception {
        return this.handler.entryGet(EntityContext.from(id, expectedPlanVersion), (Boolean)Optional.fromNullable((Object)replanning).or((Object)false));
    }

    @Override
    public Response entryPatchWithPost(String id, Long expectedPlanVersion, String clientId, RestWorkItem restWorkItem) throws Exception {
        Response response = super.entryPatchWithPost(id, expectedPlanVersion, clientId, restWorkItem);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            IssueSyncData issueSyncData = new IssueSyncData(id);
            if (restWorkItem.getTitle() != null) {
                issueSyncData.setTitle(restWorkItem.getTitle());
            }
            if (restWorkItem.getDescription() != null) {
                issueSyncData.setDescription(restWorkItem.getDescription());
            }
            this.portfolioToJiraSyncExtension.syncWorkItemToIssues(issueSyncData);
        }
        return response;
    }
}

