/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.utils.async;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.radiantminds.roadmap.common.extensions.threading.ThreadPoolExtension;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.async.RestLongRunningTaskId;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningServiceTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LongRunningService {
    private static final Log LOGGER = Log.with(LongRunningService.class);
    private static final int CACHE_DURATION = 15;
    private static final TimeUnit CACHE_UNIT = TimeUnit.MINUTES;
    private final ThreadPoolExtension threadPoolExtension;
    private static ConcurrentMap<String, LongRunningServiceTask> tasks = Maps.newConcurrentMap();
    private static ConcurrentMap<String, Future<?>> futures = Maps.newConcurrentMap();
    private static Cache<String, Response> results = CacheBuilder.newBuilder().expireAfterWrite(15L, CACHE_UNIT).removalListener((RemovalListener)new RemovalListener<Object, Object>(){

        public void onRemoval(RemovalNotification<Object, Object> notification) {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                LOGGER.info("Completed long running task expired (was not retrieved). Removed result from from cache. [" + notification.getKey() + "]", new Object[0]);
            }
        }
    }).build();
    private static Cache<String, Throwable> errors = CacheBuilder.newBuilder().expireAfterWrite(15L, CACHE_UNIT).removalListener((RemovalListener)new RemovalListener<Object, Object>(){

        public void onRemoval(RemovalNotification<Object, Object> notification) {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                LOGGER.info("Erroneous long running task expired (was not retrieved). Removed error from from cache. [" + notification.getKey() + "]", new Object[0]);
            }
        }
    }).build();

    @Autowired
    public LongRunningService(ThreadPoolExtension threadPoolExtension) {
        this.threadPoolExtension = threadPoolExtension;
    }

    private ListeningExecutorService getExecutorService() {
        return this.threadPoolExtension.listeningExecutorService(LongRunningService.class.getName(), 10);
    }

    public Response service(LongRunningServiceTask task) {
        final String serviceId = UUID.randomUUID().toString();
        tasks.put(serviceId, task);
        ListenableFuture future = this.getExecutorService().submit((Callable)task);
        results.cleanUp();
        errors.cleanUp();
        LOGGER.info(String.format("Servicing new task: [%s] (%d active, %d complete, %d erroneous)", serviceId, tasks.size(), results.size(), errors.size()), new Object[0]);
        futures.put(serviceId, (Future<?>)future);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Response>(){

            public void onSuccess(Response result) {
                LOGGER.info("Long running task completed successfully [%s]", serviceId);
                results.put((Object)serviceId, (Object)result);
                futures.remove(serviceId);
                tasks.remove(serviceId);
            }

            public void onFailure(Throwable t) {
                LOGGER.info("Long running task failed [%s]", serviceId);
                LOGGER.exception(t, Log.LogLevel.INFO);
                errors.put((Object)serviceId, (Object)t);
                futures.remove(serviceId);
                tasks.remove(serviceId);
            }
        });
        return ResponseBuilder.ok(new RestLongRunningTaskId(serviceId));
    }

    public static Response fetch(String serviceId) throws Throwable {
        Throwable error = (Throwable)errors.getIfPresent((Object)serviceId);
        if (error != null) {
            errors.invalidate((Object)serviceId);
            throw error;
        }
        Response result = (Response)results.getIfPresent((Object)serviceId);
        results.invalidate((Object)serviceId);
        return result;
    }

    public static Object getTaskState(String serviceId) throws Throwable {
        if (errors.getIfPresent((Object)serviceId) != null) {
            return LongRunningService.fetch(serviceId);
        }
        LongRunningServiceTask task = (LongRunningServiceTask)tasks.get(serviceId);
        if (task == null) {
            return null;
        }
        return task.getStatusEntity();
    }

    public static State getState(String serviceId) {
        if (futures.containsKey(serviceId)) {
            return State.RUNNING;
        }
        if (errors.getIfPresent((Object)serviceId) != null) {
            return State.ERROR;
        }
        if (results.getIfPresent((Object)serviceId) != null) {
            return State.DONE;
        }
        return State.UNKNOWN;
    }

    public static enum State {
        DONE,
        ERROR,
        RUNNING,
        UNKNOWN;

    }
}

