/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.FreeResourceTypeCalculator;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.WorkSlotStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class WorkSlotStatisticsProvider {
    private final FreeResourceTypeCalculator freeResourceTypeCalculator = new FreeResourceTypeCalculator();

    WorkSlotStatisticsProvider() {
    }

    BiMap<IWorkSlot, IWorkSlotData> getWorkSlotStatistics(Map<IWorkSlot, Set<IWorkAssignment>> slotWorkAssignments, Map<IWorkSlot, IResourceGroup> slotToGroupMap, Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> bottleneckWeight) {
        HashBiMap slotStatistics = HashBiMap.create((int)slotToGroupMap.size());
        for (Map.Entry<IWorkSlot, IResourceGroup> groupSlotsEntry : slotToGroupMap.entrySet()) {
            IResourceGroup group = groupSlotsEntry.getValue();
            BiMap<String, IWorkResource> resourceMap = RmIdentifiableUtils.createIdMap(group.getResources());
            IWorkSlot workSlot = groupSlotsEntry.getKey();
            HashSet slotAssignments = slotWorkAssignments.get(workSlot);
            if (slotAssignments == null) {
                slotAssignments = Sets.newHashSet();
            }
            PositivePrimitivesMap<IResourceType> bottleneckWeights = bottleneckWeight.get(workSlot);
            PositivePrimitivesMap<String> resourcesAvailable = WorkSlotStatisticsProvider.getAvailableWorkMap(workSlot.getIndex(), group.getResources());
            PositivePrimitivesMap<String> resourcesScheduled = WorkSlotStatisticsProvider.getScheduledWorkMap(slotAssignments);
            List<IResourceType> bottleneckTypes = WorkSlotStatisticsProvider.calculateBottleNeck(bottleneckWeights);
            double avgResourceUtilization = WorkSlotStatisticsProvider.calculateAvgResourceUtilization(resourcesAvailable, resourcesScheduled);
            double workLoad = resourcesScheduled.getValueSum();
            PositivePrimitivesMap<IResourceType> freeTypes = this.freeResourceTypeCalculator.calculateFreeTypeList(resourcesAvailable, resourcesScheduled, (Map<String, IWorkResource>)resourceMap);
            double availableWork = resourcesAvailable.getValueSum();
            WorkSlotStatistics slotStatistic = WorkSlotStatistics.create(workSlot, bottleneckTypes, bottleneckWeights, avgResourceUtilization, workLoad, freeTypes, availableWork);
            slotStatistics.put((Object)workSlot, (Object)slotStatistic);
        }
        return slotStatistics;
    }

    private static List<IResourceType> calculateBottleNeck(PositivePrimitivesMap<IResourceType> bottleneckWeight) {
        if (bottleneckWeight == null) {
            return Lists.newArrayList();
        }
        MutablePositivePrimitivesMap<IResourceType> filtered = RmCollectionUtils.newMutablePositiveMap(bottleneckWeight);
        return RmUtils.getReverseOrderWithNumericalValues(filtered);
    }

    private static double calculateAvgResourceUtilization(PositivePrimitivesMap<String> availableWorkMap, PositivePrimitivesMap<String> scheduledWorkMap) {
        Map<String, Double> utilizationPercentage = WorkSlotStatisticsProvider.calculateUtilizationPercentage(availableWorkMap, scheduledWorkMap);
        if (availableWorkMap.isEmpty()) {
            return 1.0;
        }
        double avgResourceUtilization = RmUtils.sumDoubles(utilizationPercentage.values()) / (float)availableWorkMap.size();
        if (avgResourceUtilization < (double)0.01f) {
            return 0.0;
        }
        return avgResourceUtilization;
    }

    private static Map<String, Double> calculateUtilizationPercentage(PositivePrimitivesMap<String> availableWorkMap, PositivePrimitivesMap<String> scheduledWorkMap) {
        HashMap utilizationMap = Maps.newHashMap();
        for (String key : availableWorkMap.keySet()) {
            double available = availableWorkMap.get(key);
            if (available <= 0.0) continue;
            double scheduled = scheduledWorkMap.get(key);
            double utilization = scheduled / available;
            utilizationMap.put(key, utilization);
        }
        return utilizationMap;
    }

    private static PositivePrimitivesMap<String> getScheduledWorkMap(Set<IWorkAssignment> workAssignments) {
        MutablePositivePrimitivesMap<String> workMap = RmCollectionUtils.newMutablePositiveMap();
        for (IWorkAssignment workAssignment : workAssignments) {
            String resource = workAssignment.getResource().getId();
            float value = workAssignment.getAssignedWorkUnits();
            workMap.add(resource, value);
        }
        return workMap;
    }

    private static PositivePrimitivesMap<String> getAvailableWorkMap(int slotIndex, Set<IWorkResource> resources) {
        MutablePositivePrimitivesMap<String> workMap = RmCollectionUtils.newMutablePositiveMap(resources.size());
        for (IWorkResource resource : resources) {
            float availableWork = resource.getUnassignedWorkInWorkSlot(slotIndex);
            workMap.put(resource.getId(), availableWork);
        }
        return workMap;
    }
}

