/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams.velocity;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.plans.PersonMapping;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PersonMappingImpl
implements PersonMapping {
    private final Map<String, ? extends SchedulingPerson> personMap;

    PersonMappingImpl(Map<String, ? extends SchedulingPerson> personMap) {
        this.personMap = personMap;
    }

    @Override
    public Optional<? extends SchedulingPerson> getPerson(String id) {
        return Optional.fromNullable((Object)this.personMap.get(id));
    }

    @Override
    public Collection<? extends SchedulingPerson> getPersons() {
        return this.personMap.values();
    }

    public static PersonMapping create(List<? extends SchedulingResource> resources, SchedulingPlan plan) {
        HashMap map = Maps.newHashMap();
        for (SchedulingResource schedulingResource : resources) {
            Optional<? extends SchedulingPerson> person = plan.getPerson(schedulingResource.getPersonId());
            if (!person.isPresent()) continue;
            map.put(((SchedulingPerson)person.get()).getId(), person.get());
        }
        return new PersonMappingImpl(map);
    }
}

