/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.people;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOSprint;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOTeam;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.PersonSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.SprintSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSprintPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.extensions.usermanagement.UserManagementExtension;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsSprintPersistence
extends AOSortableEntityPersistence<ISprint, AOSprint>
implements PortfolioSprintPersistence {
    private final PersonSQL personSQL;
    private final SprintSQL sprintSQL;
    private final EntityInfoSQL entityInfoSQL;
    private final PortfolioPersonPersistence personPersistence;
    private final PortfolioTeamPersistence teamPersistence;

    @Autowired
    public PortfolioActiveObjectsSprintPersistence(ActiveObjectsUtilities utils, PortfolioPersonPersistence personPersistence, PortfolioTeamPersistence teamPersistence, UserManagementExtension userManagementExtension) {
        super(utils, ISprint.class, AOSprint.class);
        this.personPersistence = personPersistence;
        this.teamPersistence = teamPersistence;
        this.personSQL = new PersonSQL(utils, userManagementExtension);
        this.sprintSQL = new SprintSQL(utils);
        this.entityInfoSQL = new EntityInfoSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioSprintPersistence.class;
    }

    @Override
    protected void transform(ISprint source, AOSprint target) throws Exception {
        TransformerUtils.transformVersionable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setStartDate(source.getStartDate());
        target.setEndDate(source.getEndDate());
        target.setTitle(source.getTitle());
        if (source.getTeam() != null) {
            target.setTeam((ITeam)this.teamPersistence.get(source.getTeam().getId()));
        }
    }

    @Override
    public EntityInfo getEntityInfo(String id) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(id, AOSprint.class, new EntityInfoSQL.ParentRelationship(AOTeam.class, "aoteam"));
    }

    @Override
    public List<ISprint> listForTeam(String teamId) throws SQLException {
        return this.sprintSQL.listForTeam(teamId);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOSprint.class, "s").withTable(AOTeam.class, "t").select().raw("s.*").from("s").leftJoin().table("t").on().col("s", "aoTeam").eq().colId("t").where().col("t", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().raw("(").select().col("t", "sortOrder").from("t").where().colId("t").eq().col("s", "aoTeam").raw("),").col("s", "sortOrder");
        }
    }
}

