/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams.teams;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StreamTeamAssignmentRequest {
    private final Set<String> teamIds;

    private StreamTeamAssignmentRequest(Set<String> teamIds) {
        this.teamIds = Collections.unmodifiableSet(teamIds);
    }

    public Set<String> getTeamIds() {
        return this.teamIds;
    }

    public String toString() {
        return "StreamTeamAssignmentRequest{, teamIds=" + this.teamIds + '}';
    }

    public static StreamTeamAssignmentRequest createNullSafe(@Nullable Collection<String> ids) {
        Set<String> idSet = StreamTeamAssignmentRequest.getIdSet(ids);
        return new StreamTeamAssignmentRequest(idSet);
    }

    private static Set<String> getIdSet(Collection<String> ids) {
        if (ids == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(ids);
    }
}

