/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.teams;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.rand.teams.ITeamsConfigurationCreator;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedTeamConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedTeamsConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.ISettingsConfiguration;
import com.radiantminds.roadmap.common.data.generator.settings.IStageConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.AbilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IAbilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamsConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.TeamConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.TeamsConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class TeamsConfigurationCreator
implements ITeamsConfigurationCreator {
    private static final String TEAM_PREFIX = "team-";

    @Override
    public ITeamsConfiguration createTeamsConfiguration(RandomizedTeamsConfiguration configuration, ISettingsConfiguration settingsConfiguration, Random random) {
        List<IStageConfiguration> stageConfigurations = settingsConfiguration.getStageConfigurations();
        LinkedHashMap<String, Set<String>> stageTitleToSkillTitlesMap = GeneratorUtils.getStageTitleToSkillTitlesMap(stageConfigurations);
        Set<String> skillTitles = RmUtils.mergeToSet(stageTitleToSkillTitlesMap.values());
        List<ITeamConfiguration> teamConfigurations = this.createTeamConfigurations(configuration, random, Lists.newArrayList(skillTitles));
        TeamsConfiguration teamsConfiguration = new TeamsConfiguration(teamConfigurations);
        return teamsConfiguration;
    }

    private List<ITeamConfiguration> createTeamConfigurations(RandomizedTeamsConfiguration configuration, Random random, List<String> skillTitles) {
        ArrayList teamConfigurations = Lists.newArrayList();
        int teamCount = configuration.getTeamsCount();
        RandomizedTeamConfiguration randomizedTeamConfiguration = configuration.getTeamConfiguration();
        for (int teamIndex = 0; teamIndex < teamCount; ++teamIndex) {
            String title = TEAM_PREFIX + teamIndex;
            List<IResourceConfiguration> resourceConfigurations = this.createResourceConfigurations(randomizedTeamConfiguration, teamIndex, random, skillTitles);
            TeamConfiguration teamConfiguration = new TeamConfiguration(title, resourceConfigurations);
            teamConfigurations.add(teamConfiguration);
        }
        return teamConfigurations;
    }

    private List<IResourceConfiguration> createResourceConfigurations(RandomizedTeamConfiguration teamConfiguration, int teamIndex, Random random, List<String> skillTitles) {
        ArrayList resourceConfigurations = Lists.newArrayList();
        int resourceCount = GeneratorUtils.getRandomFromInterval(teamConfiguration.getMinResourcesCount(), teamConfiguration.getMaxResourceCount(), random);
        RandomizedResourceConfiguration randomizedResourceConfiguration = teamConfiguration.getResourceConfiguration();
        for (int resourceIndex = 0; resourceIndex < resourceCount; ++resourceIndex) {
            IResourceConfiguration resourceConfiguration = this.createResourceConfiguration(resourceIndex, teamIndex, randomizedResourceConfiguration, random, skillTitles);
            resourceConfigurations.add(resourceConfiguration);
        }
        return resourceConfigurations;
    }

    private IResourceConfiguration createResourceConfiguration(int resourceIndex, int teamIndex, RandomizedResourceConfiguration randomizedResourceConfiguration, Random random, List<String> skillTitles) {
        String title = TEAM_PREFIX + teamIndex + "-" + resourceIndex;
        Set<IAbilityConfiguration> abilityConfigurations = this.createAbilityConfigurations(randomizedResourceConfiguration, skillTitles, random);
        Double availability = 40.0;
        ResourceConfiguration resourceConfiguration = new ResourceConfiguration.Builder(title).withAbilityConfigurations(abilityConfigurations).withAvailability(availability).build();
        return resourceConfiguration;
    }

    private Set<IAbilityConfiguration> createAbilityConfigurations(RandomizedResourceConfiguration randomizedResourceConfiguration, List<String> allSkillTitles, Random random) {
        int skillCount = GeneratorUtils.getRandomFromInterval(randomizedResourceConfiguration.getMinNumberSkills(), randomizedResourceConfiguration.getMaxNumberSkills(), random);
        List<String> selectedSkills = GeneratorUtils.selectRandomSubset(allSkillTitles, skillCount, random);
        HashSet abilityConfigurations = Sets.newHashSetWithExpectedSize((int)skillCount);
        for (String skill : selectedSkills) {
            AbilityConfiguration abilitiyConfiguration = new AbilityConfiguration(skill, 1.0);
            abilityConfigurations.add(abilitiyConfiguration);
        }
        return abilityConfigurations;
    }
}

