/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.teams;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.generator.rand.teams.RandomizedResourceConfiguration;

public class RandomizedTeamConfiguration {
    private final int minResourcesCount;
    private final int maxResourceCount;
    private final RandomizedResourceConfiguration resourceConfiguration;

    public RandomizedTeamConfiguration(int minResourcesCount, int maxResourceCount, RandomizedResourceConfiguration resourceConfiguration) {
        this.minResourcesCount = minResourcesCount;
        this.maxResourceCount = maxResourceCount;
        this.resourceConfiguration = resourceConfiguration;
    }

    public int getMinResourcesCount() {
        return this.minResourcesCount;
    }

    public int getMaxResourceCount() {
        return this.maxResourceCount;
    }

    public RandomizedResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public static class Builder {
        private int minResourcesCount = 5;
        private int maxResourcesCount = 15;
        private RandomizedResourceConfiguration resourceConfiguration = new RandomizedResourceConfiguration.Builder().build();

        public Builder withResourceCountBetween(int minResourcesCount, int maxResourcesCount) {
            Preconditions.checkArgument((minResourcesCount <= maxResourcesCount ? 1 : 0) != 0);
            this.minResourcesCount = minResourcesCount;
            this.maxResourcesCount = maxResourcesCount;
            return this;
        }

        public Builder withResourceConfiguration(RandomizedResourceConfiguration resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
            return this;
        }

        public RandomizedTeamConfiguration build() {
            return new RandomizedTeamConfiguration(this.minResourcesCount, this.maxResourcesCount, this.resourceConfiguration);
        }
    }
}

