/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.workitems;

import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimationEnrichedWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItemExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemType;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestRankableDescribable;
import com.radiantminds.roadmap.common.rest.entities.common.IReplanningAware;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimateBlock;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestProgress;
import com.radiantminds.roadmap.common.rest.entities.workitems.links.RestWorkItemExtensionLinkResponse;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="workItem")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestWorkItem
extends BaseRestRankableDescribable
implements IWorkItem,
IEstimationEnrichedWorkItem,
IReplanningAware {
    @XmlElement
    private RestEstimateBlock estimates;
    @XmlElement
    private RestEstimateBlock replanningEstimates;
    @XmlElement
    private RestEstimateBlock originalEstimates;
    @XmlElement
    private Boolean hasOriginalEstimates;
    @XmlElement
    private String parentId;
    @XmlElement
    private String releaseId;
    @XmlElement
    private String teamId;
    @XmlElement
    private String sprintId;
    @XmlElement
    private String streamId;
    @XmlElement
    private String themeId;
    @XmlElement
    private Set<String> resourceIds;
    @XmlElement
    private String replanningTeamId;
    @XmlElement
    private Boolean replanningTeamSet;
    @XmlElement
    private String replanningStreamId;
    @XmlElement
    private String replanningReleaseId;
    @XmlElement
    private Set<String> replanningResourceIds;
    @XmlElement
    private List<RestWorkItem> children;
    @XmlElement
    @SchedulingRelevantPatch
    private Long earliestStart;
    @XmlElement
    @SchedulingRelevantPatch
    private Long targetStart;
    @XmlElement
    @SchedulingRelevantPatch
    private Long targetEnd;
    @XmlElement
    private Integer status;
    @XmlElement
    private Integer replanningStatus;
    @XmlElement
    private Double businessValue;
    @XmlElement
    private List<RestWorkItemExtensionLinkResponse> links;
    @XmlElement
    private List<String> prerequisites;
    @XmlElement
    private RestProgress progress;
    @XmlElement
    private Integer workItemType;
    private IStream stream;
    private IRelease release;
    private ITheme theme;
    private ITeam team;
    private ISprint sprint;
    protected IWorkItem parent;
    protected IPlan plan;

    private void initEstimateBlocks() {
        this.estimates = new RestEstimateBlock();
        this.replanningEstimates = new RestEstimateBlock();
        this.originalEstimates = new RestEstimateBlock();
    }

    @Deprecated
    protected RestWorkItem() {
        this.initEstimateBlocks();
    }

    public static RestWorkItem createForEnrichment(String id) {
        RestWorkItem retVal = new RestWorkItem(id, null, null);
        retVal.estimates = null;
        retVal.originalEstimates = null;
        retVal.replanningEstimates = null;
        retVal.status = null;
        return retVal;
    }

    public RestWorkItem(String id, String title, String description) {
        super(id, title, description);
        this.initEstimateBlocks();
        this.status = WorkItemStatus.OPEN.value();
    }

    @Override
    public String getReplanningReleaseId() {
        return this.replanningReleaseId;
    }

    @Override
    public String getReplanningTeamId() {
        return this.replanningTeamId;
    }

    @Override
    public String getReplanningStreamId() {
        return this.replanningStreamId;
    }

    @Override
    public boolean isReplanningTeamSet() {
        return this.replanningTeamSet;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getReleaseId() {
        return this.releaseId;
    }

    @Override
    public Optional<String> getTeamId() {
        return Optional.fromNullable((Object)this.teamId);
    }

    @Override
    public Optional<String> getSprintId() {
        return Optional.fromNullable((Object)this.sprintId);
    }

    @Override
    public RestProgress getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(RestProgress progress) {
        this.progress = progress;
    }

    @Override
    public Integer getType() {
        return this.workItemType;
    }

    @Override
    public void setType(Integer type) {
        this.workItemType = type;
    }

    @Override
    public Integer getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public Integer getReplanningStatus() {
        return this.replanningStatus;
    }

    @Override
    public void setReplanningStatus(Integer replanningStatus) {
        this.replanningStatus = replanningStatus;
    }

    @Override
    public Optional<Double> getBusinessValue() {
        return Optional.fromNullable((Object)this.businessValue);
    }

    @Override
    public void setBusinessValue(Double businessValue) {
        this.businessValue = businessValue;
    }

    @Override
    public Long getEarliestStart() {
        return this.earliestStart;
    }

    @Override
    public void setEarliestStart(Long date) {
        this.earliestStart = date;
    }

    @Override
    public Optional<Long> getTargetStart() {
        return Optional.fromNullable((Object)this.targetStart);
    }

    @Override
    public void setTargetStart(Long date) {
        this.targetStart = date;
    }

    @Override
    public Optional<Long> getTargetEnd() {
        return Optional.fromNullable((Object)this.targetEnd);
    }

    @Override
    public void setTargetEnd(Long date) {
        this.targetEnd = date;
    }

    @Override
    public List<? extends IWorkItem> getChildren() {
        return this.children;
    }

    @Override
    public List<? extends IEstimationEnrichedWorkItem> getEstimationEnrichedChildren() {
        return this.children;
    }

    public List<RestWorkItem> getRestChildren() {
        return this.children;
    }

    public void addChild(RestWorkItem child) {
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        this.children.add(child);
    }

    public List<RestWorkItemExtensionLinkResponse> getRestExtensionLinks() {
        if (this.links == null) {
            return Lists.newArrayList();
        }
        return this.links;
    }

    public void setChildren(List<RestWorkItem> children) {
        this.children = children;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public IWorkItem getParent() {
        return this.parent;
    }

    @Override
    public IEstimationEnrichedWorkItem getEstimationEnrichedParent() {
        return (IEstimationEnrichedWorkItem)this.parent;
    }

    @Override
    public void setParent(IWorkItem workItem) {
        this.parent = workItem;
        this.parentId = workItem != null ? workItem.getId() : null;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public IPlan getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(IPlan plan) {
        this.plan = plan;
        this.setOrderRangeIdentifier("plan-" + plan.getId());
    }

    @Override
    public Optional<IRelease> getRelease() {
        return Optional.fromNullable((Object)this.release);
    }

    @Override
    public void setRelease(IRelease release) {
        this.release = release;
        this.releaseId = release != null ? release.getId() : null;
    }

    @Override
    public Optional<IStream> getStream() {
        return Optional.fromNullable((Object)this.stream);
    }

    @Override
    public void setStream(IStream stream) {
        this.stream = stream;
        this.streamId = stream != null ? stream.getId() : null;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public Optional<ITheme> getTheme() {
        return Optional.fromNullable((Object)this.theme);
    }

    @Override
    public void setTheme(ITheme theme) {
        this.theme = theme;
        if (theme != null) {
            this.themeId = theme.getId();
        } else {
            this.theme = null;
        }
    }

    @Override
    public Optional<String> getThemeId() {
        return Optional.fromNullable((Object)this.themeId);
    }

    @Override
    public Optional<ITeam> getTeam() {
        return Optional.fromNullable((Object)this.team);
    }

    @Override
    public Optional<ISprint> getSprint() {
        return Optional.fromNullable((Object)this.sprint);
    }

    @Override
    public void setTeam(ITeam team) {
        this.team = team;
        this.teamId = this.team != null ? this.team.getId() : null;
    }

    @Override
    public void setSprint(ISprint sprint) {
        this.sprint = sprint;
        this.sprintId = this.sprint != null ? this.sprint.getId() : null;
    }

    @Override
    public void nullifyReplanningData() {
        this.clearReplanning(null);
    }

    @Override
    public void clearReplanning(ActiveObjectsUtilities utils) {
        this.replanningReleaseId = null;
        this.replanningTeamId = null;
        this.replanningStreamId = null;
        this.replanningTeamSet = null;
        this.replanningStatus = null;
    }

    @Override
    public void applyReplanning(ActiveObjectsUtilities utils, Long replanningDate) {
        if (this.replanningTeamSet != null && this.replanningTeamSet.booleanValue()) {
            this.setTeamId(this.replanningTeamId);
        }
        if (this.replanningStatus != null) {
            this.status = this.replanningStatus;
        }
        if (this.getSprint().isPresent() && replanningDate != null && ((ISprint)this.getSprint().get()).getEndDate() < replanningDate) {
            this.setSprint(null);
        }
    }

    @Override
    public List<IExtensionLink> getExtensionLinks() {
        if (this.links == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(this.links);
    }

    @Override
    public void removeExtensionLink(IExtensionLink link) {
        if (this.links != null) {
            this.links.remove(link);
        }
    }

    public void setExtensionLinks(@Nullable List<IWorkItemExtensionLink> links) {
        this.links = this.toRestLinks(links);
    }

    private List<RestWorkItemExtensionLinkResponse> toRestLinks(@Nullable List<IWorkItemExtensionLink> links) {
        if (links == null) {
            return null;
        }
        ArrayList restLinks = Lists.newArrayList();
        for (IWorkItemExtensionLink link : links) {
            restLinks.add(new RestWorkItemExtensionLinkResponse(link));
        }
        return restLinks;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public void setSprintId(String sprintId) {
        this.sprintId = sprintId;
    }

    public void setReplanningTeamId(String teamId) {
        this.replanningTeamId = teamId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public void setReplanningReleaseId(String releaseId) {
        this.replanningReleaseId = releaseId;
    }

    public void setReplanningStreamId(String streamId) {
        this.replanningStreamId = streamId;
    }

    @Override
    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<String> dependees) {
        this.prerequisites = dependees;
    }

    public void setInsertAfter(String insertAfter) {
        this.insertAfter = insertAfter;
    }

    public void setInsertBefore(String insertBefore) {
        this.insertBefore = insertBefore;
    }

    public void setReplanningTeamSet(Boolean replanningTeamSet) {
        this.replanningTeamSet = replanningTeamSet;
    }

    @Override
    public Set<String> getResources() {
        if (this.resourceIds != null) {
            return this.resourceIds;
        }
        return Sets.newHashSet();
    }

    @Override
    public Optional<? extends SchedulingEstimate> getEstimateForSkill(String skillId) {
        return this.getCurrentEstimates().getEstimateForSkill(skillId);
    }

    @Override
    public Optional<? extends SchedulingEstimate> getEstimateForStage(String stageEstimate) {
        return this.getCurrentEstimates().getEstimateForStage(stageEstimate);
    }

    @Override
    public Set<String> getStreamTeamRestrictions() {
        if (this.stream != null) {
            return this.stream.getTeams();
        }
        return Sets.newHashSet();
    }

    @Override
    public Set<String> getChildIds() {
        return RmIdentifiableUtils.getIds(this.getChildren());
    }

    @Override
    public Set<String> getResourceIds() {
        return this.getResources();
    }

    @Override
    public WorkItemType getWorkItemType() {
        return WorkItemType.fromCode(this.getType());
    }

    @Override
    public boolean isStory() {
        return this.getWorkItemType() == WorkItemType.Story;
    }

    @Override
    public boolean isEpic() {
        return this.getWorkItemType() == WorkItemType.Epic;
    }

    @Override
    public boolean isInitiative() {
        return this.getWorkItemType() == WorkItemType.Initiative;
    }

    @Override
    public boolean canHaveParent() {
        return this.getWorkItemType().canHaveParent();
    }

    public void setResources(Set<String> resources) {
        this.resourceIds = resources;
    }

    @Override
    public Set<String> getReplanningResources() {
        if (this.replanningResourceIds != null) {
            return this.replanningResourceIds;
        }
        return Sets.newHashSet();
    }

    @Override
    public IEstimateBlock getCurrentEstimates() {
        return this.estimates;
    }

    @Override
    public IEstimateBlock getReplanningEstimates() {
        return this.replanningEstimates;
    }

    @Override
    public IEstimateBlock getOriginalEstimates() {
        return this.originalEstimates;
    }

    @Override
    public Boolean getHasOriginalEstimates() {
        return this.hasOriginalEstimates;
    }

    @Override
    public void setHasOriginalEstimates(Boolean hasOriginalEstimates) {
        this.hasOriginalEstimates = hasOriginalEstimates;
    }

    public void setReplanningResources(Set<String> resources) {
        this.replanningResourceIds = resources;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    @Override
    public Optional<SchedulingEstimate> getTotalEstimate() {
        return Optional.fromNullable((Object)this.estimates.getTotal().orNull());
    }

    @Override
    public Collection<SchedulingEstimate> getSkillEstimates() {
        return Collections.unmodifiableCollection(this.estimates.getSkills());
    }

    @Override
    public Collection<SchedulingEstimate> getStageEstimates() {
        return Collections.unmodifiableCollection(this.estimates.getStages());
    }
}

