/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.issue.IssueManagerBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.project.ProjectManagerBridgeProxy;
import com.atlassian.rm.common.bridges.jira.search.SearchServiceBridgeProxy;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueLinksResult;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueResult;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.IssueLinkRequest;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.SyncRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.extensions.workitems.search.IIssueSearchResult;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.JiraUserManagementExtension;
import com.radiantminds.roadmap.jira.common.components.extension.filters.JiraIssueFilterUtil;
import com.radiantminds.roadmap.jira.common.components.extension.issues.create.CreateIssueRequestHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.IssueDataRequestHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.LuceneJiraIssueAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.CreateIssueLinksRequestHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.IJiraIssueRequest;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.IJiraIssueRequestHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.JiraIssueRequest;
import com.radiantminds.roadmap.jira.common.components.extension.issues.search.JiraIssueRequestHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.IssueSyncronizationRequestHandler;
import com.radiantminds.roadmap.jira.common.components.sync.SynchronizationFlagHandler;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraWorkItemExtension
implements WorkItemExtension {
    private static final Log LOGGER = Log.with(JiraWorkItemExtension.class);
    private final JiraIssueFilterUtil issueFilterUtil;
    private final IJiraIssueRequestHandler issueRequestHandler;
    private final IssueSyncronizationRequestHandler issueSyncronizationRequestHandler;
    private final CreateIssueRequestHandler createIssueRequestHandler;
    private final IssueDataRequestHandler issueDataRequestHandler;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final CreateIssueLinksRequestHandler createIssueLinksRequestHandler;

    @Autowired
    public JiraWorkItemExtension(IssueManager issueManager, IssueManagerBridgeProxy issueManagerBridgeProxy, IssueFactory issueFactory, IssueService issueService, IssueServiceBridgeProxy issueServiceBridgeProxy, IssueLinkManager issueLinkManager, IssueLinkService issueLinkService, IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy, IssueLinkTypeManager issueLinkTypeManager, SearchServiceBridgeProxy searchServiceBridgeProxy, ProjectManagerBridgeProxy projectManagerBridgeProxy, ConstantsManager constantsManager, JiraAuthenticationContext authenticationContext, SearchRequestService searchRequestService, LocaleManager localeManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, VersionManager versionManager, PriorityManager priorityManager, JiraAgileAccessor agileAccessor, LuceneJiraIssueAccessor luceneJiraIssueAccessor, CustomFields customFields, PersistenceIndex persistenceIndex, PortfolioResourcePersistence resourcePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, JiraUserManagementExtension jiraUserManagementExtension, FeatureExtension featureExtension, SynchronizationFlagHandler flagHandler) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.issueFilterUtil = new JiraIssueFilterUtil(searchRequestService);
        this.issueRequestHandler = JiraIssueRequestHandler.createInstance(searchServiceBridgeProxy, issueManager, agileAccessor, customFields);
        this.issueSyncronizationRequestHandler = new IssueSyncronizationRequestHandler(flagHandler, customFields, localeManager, applicationProperties, authenticationContext, issueService, issueServiceBridgeProxy, versionManager, permissionManager, issueLinkManager, issueLinkService, issueLinkServiceBridgeProxy, issueLinkTypeManager, persistenceIndex, resourcePersistence, extensionLinkPersistence, jiraUserManagementExtension, featureExtension);
        this.issueDataRequestHandler = new IssueDataRequestHandler(agileAccessor, customFields, luceneJiraIssueAccessor);
        this.createIssueRequestHandler = new CreateIssueRequestHandler(issueManager, issueManagerBridgeProxy, issueFactory, projectManagerBridgeProxy, constantsManager, authenticationContext, applicationProperties, permissionManager, versionManager, priorityManager, customFields);
        this.createIssueLinksRequestHandler = new CreateIssueLinksRequestHandler(issueLinkManager, issueLinkServiceBridgeProxy, issueLinkTypeManager, authenticationContext, issueServiceBridgeProxy, featureExtension);
    }

    @Override
    public MonitoredCallResult<WorkItemExtensionLinkData> getExtensionLinkData(ProgressConfiguration progressConfiguration, Set<String> issueKeys) throws Exception {
        return this.issueDataRequestHandler.getData(issueKeys, progressConfiguration);
    }

    @Override
    public CreateIssueLinksResult createIssueLinksForDependencies(IssueLinkRequest request) throws Exception {
        return this.createIssueLinksRequestHandler.createIssueLinksForDependencies(request);
    }

    @Override
    public IIssueSearchResult find(IIssueRequest request) throws Exception {
        LOGGER.debug("find issues for request: %s", request);
        IJiraIssueRequest jiraRequest = JiraIssueRequest.createInstance(request, this.applicationProperties, this.authenticationContext);
        IIssueSearchResult result = this.issueRequestHandler.getResult(jiraRequest);
        LOGGER.debug("found results: %s", result);
        return result;
    }

    @Override
    public List<ViolationMessage> syncToExtention(SyncRequest request) throws Exception {
        return this.issueSyncronizationRequestHandler.syncToExtention(request);
    }

    @Override
    public CreateIssueResult createIssue(CreateIssueRequest request) throws Exception {
        return this.createIssueRequestHandler.createIssue(request);
    }
}

