/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.AssignmentUtils;
import com.radiantminds.roadmap.jira.common.components.utils.JiraPropertyUtil;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class FormattingUtils {
    private static final Log LOGGER = Log.with(AssignmentUtils.class);

    public static final String formatStoryPoints(Locale locale, Double storyPoints) {
        String formattedStoryPoints = locale != null ? String.format(locale, "%f", storyPoints) : storyPoints.toString();
        return formattedStoryPoints;
    }

    public static String toJiraMinuteString(Double estimate, String planningUnit, Double hoursPerDay) {
        Double factor = 60.0;
        if (PlanningUnit.DAYS.toString().equals(planningUnit)) {
            factor = factor * hoursPerDay;
        }
        return Long.toString(Math.round(estimate * factor)) + "m";
    }

    public static final SimpleDateFormat getDateFormat(ApplicationProperties applicationProperties, Locale locale) {
        SimpleDateFormat dateFormat;
        if (locale != null) {
            LOGGER.info("Successfully retrieved locale for user = %s", locale.toString());
            dateFormat = new SimpleDateFormat(JiraPropertyUtil.getValueOrDefault(applicationProperties, "jira.date.picker.java.format"), locale);
        } else {
            LOGGER.info("Could not get locale for active user, default locale will be used.", new Object[0]);
            dateFormat = new SimpleDateFormat(JiraPropertyUtil.getValueOrDefault(applicationProperties, "jira.date.picker.java.format"));
        }
        return dateFormat;
    }
}

