/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.skills;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOStage;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.sql.SkillSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsSkillPersistence
extends AOSortableEntityPersistence<ISkill, AOSkill>
implements PortfolioSkillPersistence {
    private final EntityInfoSQL entityInfoSQL;
    private final SkillSQL skillSQL;
    private final PortfolioEstimatePersistence estimatePersistence;
    private final PortfolioStagePersistence stagePersistence;

    @Autowired
    public PortfolioActiveObjectsSkillPersistence(ActiveObjectsUtilities utils, PortfolioEstimatePersistence estimatePersistence, PortfolioStagePersistence stagePersistence) {
        super(utils, ISkill.class, AOSkill.class);
        this.estimatePersistence = estimatePersistence;
        this.stagePersistence = stagePersistence;
        this.entityInfoSQL = new EntityInfoSQL(utils);
        this.skillSQL = new SkillSQL(utils);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioSkillPersistence.class;
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        try {
            this.estimatePersistence.clearEstimatesForTarget("skill", id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to clear estimates for skill " + id + " on deletion.", ex);
        }
        try {
            this.deleteAllSkillAbilities(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to clear abilities for skill " + id + " on deletion.", ex);
        }
        return super.delete(id, inCascade);
    }

    @Override
    protected void transform(ISkill source, AOSkill target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        if (source.getStage() != null) {
            target.setStage((IStage)this.stagePersistence.get(source.getStage().getId()));
        }
        target.setPercentage(source.getPercentage());
    }

    @Override
    public EntityInfo getEntityInfo(String skillId) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(skillId, AOSkill.class, new EntityInfoSQL.ParentRelationship(AOStage.class, "aoStage"));
    }

    @Override
    public List<ISkill> listCustom(String stageId) throws SQLException {
        return this.skillSQL.getSkillsForStage(stageId);
    }

    @Override
    public void deleteAllSkillAbilities(String id) throws SQLException {
        this.skillSQL.deleteAllSkillAbilities(id);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOSkill.class, "t").withTable(AOStage.class, "h1").withTable(AOStage.class, "h2").select().raw("t.*").from("t").leftJoin().table("h1").on().col("t", "aoStage").eq().colId("h1").where().col("h1", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy().raw("(").select().col("h2", "sortOrder").from("h2").where().colId("h2").eq().col("t", "aostage").raw("),").col("t", "sortOrder");
        }
    }
}

