/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ITeamAvailabilityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ITeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.google.common.base.Preconditions;

public class FixedGroupPointsResourceSupplyFunction
implements IWorkSlotFunction {
    private final IWorkSlotFunction resourceAvailabilityFunction;
    private final ITeamAvailabilityFunction teamAvailabilityFunction;
    private final ITeamVelocityFunction teamVelocityFunction;

    public FixedGroupPointsResourceSupplyFunction(IWorkSlotFunction resourceAvailabilityFunction, ITeamAvailabilityFunction teamAvailabilityFunction, ITeamVelocityFunction teamVelocityFunction) {
        Preconditions.checkArgument((teamAvailabilityFunction.isPositiveEnding() || !resourceAvailabilityFunction.isPositiveEnding() ? 1 : 0) != 0, (Object)"incompatible availability functions");
        Preconditions.checkArgument((teamAvailabilityFunction.getFirstRegularTimeStep() >= resourceAvailabilityFunction.getFirstRegularTimeStep() ? 1 : 0) != 0, (Object)"incompatible availability functions");
        this.resourceAvailabilityFunction = resourceAvailabilityFunction;
        this.teamAvailabilityFunction = teamAvailabilityFunction;
        this.teamVelocityFunction = teamVelocityFunction;
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        float teamAvailable = this.teamAvailabilityFunction.getUnassignedWorkInWorkSlot(slotIndex);
        if (teamAvailable <= 0.0f) {
            return 0.0f;
        }
        float resourceAvailable = this.resourceAvailabilityFunction.getUnassignedWorkInWorkSlot(slotIndex);
        float availabilityFactor = resourceAvailable / teamAvailable;
        float teamVelocity = this.teamVelocityFunction.getVelocity(slotIndex);
        return teamVelocity * availabilityFactor;
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        float teamAvailable = this.teamAvailabilityFunction.getRestrictedAvailability(slotIndex);
        if (teamAvailable <= 0.0f) {
            return 0.0f;
        }
        float resourceAvailable = this.resourceAvailabilityFunction.getRestrictedAvailability(slotIndex);
        float availabilityFactor = resourceAvailable / teamAvailable;
        float teamVelocity = this.teamVelocityFunction.getVelocity(slotIndex);
        return teamVelocity * availabilityFactor;
    }

    @Override
    public int getFirstRegularTimeStep() {
        return this.resourceAvailabilityFunction.getFirstRegularTimeStep();
    }

    @Override
    public boolean isPositiveEnding() {
        return this.resourceAvailabilityFunction.isPositiveEnding() && this.teamVelocityFunction.isPositiveEnding();
    }
}

