/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.backlog.AbstractWorkItemConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEstimateConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IStoryConfiguration;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Immutable
public class StoryConfiguration
extends AbstractWorkItemConfiguration
implements IStoryConfiguration {
    StoryConfiguration(String title, Set<IEstimateConfiguration> estimationConfigurations, String releaseTitle, String teamTitle, String streamTitle, Long earliestStart) {
        super(title, estimationConfigurations, releaseTitle, teamTitle, streamTitle, earliestStart);
    }

    public static class Builder {
        private final String title;
        private Set<IEstimateConfiguration> estimationConfigurations = Sets.newHashSet();
        private String releaseTitle = null;
        private String teamTitle = null;
        private String streamTitle = null;
        private Long earliestStart = null;

        public Builder(String title) {
            this.title = title;
        }

        public Builder withEstimationConfigurations(Set<IEstimateConfiguration> estimationConfigurations) {
            this.estimationConfigurations = estimationConfigurations;
            return this;
        }

        public Builder withReleaseTitle(String releaseTitle) {
            this.releaseTitle = releaseTitle;
            return this;
        }

        public Builder withTeamTitle(String teamTitle) {
            this.teamTitle = teamTitle;
            return this;
        }

        public Builder withStreamTitle(String streamTitle) {
            this.streamTitle = streamTitle;
            return this;
        }

        public Builder withEarliestStart(String startDate) {
            this.earliestStart = GeneratorUtils.parseDate(startDate);
            return this;
        }

        public Builder withEarliestStart(DateTime startDate) {
            this.earliestStart = startDate.withZone(DateTimeZone.UTC).getMillis();
            return this;
        }

        public StoryConfiguration build() {
            return new StoryConfiguration(this.title, this.estimationConfigurations, this.releaseTitle, this.teamTitle, this.streamTitle, this.earliestStart);
        }
    }
}

