/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync.workitems;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.workitems.SyncRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.common.handlers.sync.SyncOperationResult;
import com.radiantminds.roadmap.common.handlers.sync.SyncUtils;
import com.radiantminds.roadmap.common.handlers.sync.workitems.DuplicateWorkItemLinkDetailsProvider;
import com.radiantminds.roadmap.common.handlers.sync.workitems.ValidatedWorkItemSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncServiceHandler;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.rest.entities.workitems.dependencies.RestWorkItemDependencies;
import com.radiantminds.roadmap.common.scheduling.Calculation;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import com.radiantminds.roadmap.common.utils.dependencies.DependencyUtils;
import com.radiantminds.roadmap.common.utils.stages.StagePercentageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class WorkItemSyncServiceHandlerImpl
implements WorkItemSyncServiceHandler {
    private static final Log LOGGER = Log.with(WorkItemSyncServiceHandler.class);
    private final AnalyticsExtension analyticsExtension;
    private final PortfolioPlanPersistence planPersistence;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioStagePersistence stagePersistence;
    private final PortfolioExtensionLinkPersistence extensionLinkPersistence;
    private final WorkItemExtension workItemExtension;
    private final Scheduling scheduling;

    public WorkItemSyncServiceHandlerImpl(PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioStagePersistence stagePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, AnalyticsExtension analyticsExtension, WorkItemExtension workItemExtension, Scheduling scheduling) {
        this.analyticsExtension = analyticsExtension;
        this.workItemExtension = workItemExtension;
        this.planPersistence = planPersistence;
        this.workItemPersistence = workItemPersistence;
        this.stagePersistence = stagePersistence;
        this.extensionLinkPersistence = extensionLinkPersistence;
        this.scheduling = scheduling;
    }

    @Override
    public SyncOperationResult syncWorkitems(EntityContext<IPlan> entityContext, ValidatedWorkItemSyncConfiguration config) throws Exception {
        if (config == null) {
            LOGGER.debug("nothing to do for request configuration", new Object[0]);
            return SyncOperationResult.EMPTY;
        }
        this.analyticsExtension.publishSyncWorkItemsEvent(config.isAssigneeSynced(), config.isDueDateSynced(), config.isEstimateSynced(), config.getWorkItemIds().size());
        String planId = entityContext.getEntityId();
        List<IStage> stages = this.stagePersistence.listCustom(planId);
        Map<String, Double> stagePercentages = StagePercentageUtil.computeStagePercentages(stages);
        String planningUnit = this.planPersistence.getPlanConfiguration(planId).getPlanningUnit();
        Double hoursPerDay = this.planPersistence.getPlanConfiguration(planId).getHoursPerDay();
        List<? extends IWorkItem> workItems = this.workItemPersistence.listPlainWorkItemsForPlanForIds(planId, config.getWorkItemIds(), false);
        Map<String, IWorkItem> idToWorkItemMap = WorkItemSyncServiceHandlerImpl.mapIdsToWorkItems(workItems, config.getWorkItemIds());
        RestSchedulingSolution solution = (RestSchedulingSolution)this.tryExtractPlanSolution(planId).orNull();
        SyncOperationResult.Impl result = new SyncOperationResult.Impl();
        if (config.isDueDateSynced() && solution == null) {
            LOGGER.warn("Cannot sync estimates to Jira because there is no solution.", new Object[0]);
            result.addGlobalWarning("sync-estimates-no-solution");
        }
        DuplicateWorkItemLinkDetailsProvider detailsProvider = new DuplicateWorkItemLinkDetailsProvider();
        List<ViolationMessage> multipleLinkWarnings = SyncUtils.checkForDuplicateIssueLinks(idToWorkItemMap.values(), detailsProvider);
        result.addGlobalViolations(multipleLinkWarnings);
        HashMap globalMessages = Maps.newHashMap();
        for (String id : config.getWorkItemIds()) {
            result.addProcessedItem(id);
            ArrayList violations = Lists.newArrayList();
            ArrayList inwardDependencyIssueKeys = Lists.newArrayList();
            ArrayList outwardDependencyIssueKeys = Lists.newArrayList();
            if (config.areIssueLinksSynced()) {
                RestWorkItemDependencies dependencies = this.workItemPersistence.getDependencies(id, true);
                List<String> inwardDependencyItemIds = DependencyUtils.getRealDependencies(dependencies.getRequires());
                List<String> outwardDependencyItemIds = DependencyUtils.getRealDependencies(dependencies.getRequiredBy());
                inwardDependencyIssueKeys.addAll(DependencyUtils.getLinkedIssueKeysForWorkItemIds(this.extensionLinkPersistence, inwardDependencyItemIds));
                outwardDependencyIssueKeys.addAll(DependencyUtils.getLinkedIssueKeysForWorkItemIds(this.extensionLinkPersistence, outwardDependencyItemIds));
            }
            try {
                List<ViolationMessage> clearedMessages;
                List<ViolationMessage> messages = this.workItemExtension.syncToExtention(new SyncRequest(idToWorkItemMap.get(id), config, planningUnit, hoursPerDay, stages, stagePercentages, solution, inwardDependencyIssueKeys, outwardDependencyIssueKeys));
                if (messages != null && (clearedMessages = WorkItemSyncServiceHandlerImpl.aggregateMessages(globalMessages, messages)) != null) {
                    violations.addAll(clearedMessages);
                }
                if (violations.size() <= 0) continue;
                result.setItemViolations(id, violations);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to sync issue %s to Jira.", idToWorkItemMap.get(id));
                LOGGER.exception(e, Log.LogLevel.WARN);
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                String message = rootCause != null ? rootCause.getMessage() : null;
                result.setItemViolations(id, Lists.newArrayList((Object[])new ViolationMessage[]{new ViolationMessage.Impl("error", message != null ? message : "Unknown exception")}));
            }
        }
        result.addGlobalViolations(globalMessages.values());
        return result;
    }

    private Optional<RestSchedulingSolution> tryExtractPlanSolution(String planId) {
        Calculation calculation = (Calculation)this.scheduling.getSolutionForPlan(planId).orNull();
        if (calculation == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)calculation.getTransferableSolution());
    }

    private static List<ViolationMessage> aggregateMessages(Map<String, ViolationMessage> globalMessages, List<ViolationMessage> messages) {
        ArrayList clearedMessages = Lists.newArrayList();
        HashSet messagesFilter = Sets.newHashSet((Object[])new String[]{"sync-time-tracking-disabled", "sync-story-points-field-missing", "jira-issue-linking-disabled", "jira-issue-linking-invalid-type"});
        for (ViolationMessage message : messages) {
            String plainMessage = message.getMessage();
            if (messagesFilter.contains(plainMessage)) {
                if (globalMessages.containsKey(plainMessage)) continue;
                globalMessages.put(plainMessage, message);
                continue;
            }
            clearedMessages.add(message);
        }
        return clearedMessages.size() > 0 ? clearedMessages : null;
    }

    private static final Map<String, IWorkItem> mapIdsToWorkItems(List<? extends IWorkItem> workItems, List<String> requiredIds) {
        HashMap<String, IWorkItem> retVal = new HashMap<String, IWorkItem>();
        if (requiredIds != null && requiredIds.size() > 0) {
            for (IWorkItem iWorkItem : workItems) {
                retVal.putAll(WorkItemSyncServiceHandlerImpl.mapAllChildIds(iWorkItem, requiredIds));
            }
        }
        return retVal;
    }

    private static final Map<String, IWorkItem> mapAllChildIds(IWorkItem workItem, List<String> requiredIds) {
        HashMap<String, IWorkItem> retVal = new HashMap<String, IWorkItem>();
        for (IWorkItem iWorkItem : workItem.getChildren()) {
            if (requiredIds.contains(iWorkItem.getId())) {
                retVal.put(iWorkItem.getId(), iWorkItem);
            }
            retVal.putAll(WorkItemSyncServiceHandlerImpl.mapAllChildIds(iWorkItem, requiredIds));
        }
        if (requiredIds.contains(workItem.getId())) {
            retVal.put(workItem.getId(), workItem);
        }
        return retVal;
    }
}

