/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.sql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.permissions.AOPermission;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserData;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlan;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlanSQL
extends BaseAOPersistenceSQL {
    private final PortfolioPlanPersistence planPersistence;

    public PlanSQL(ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence) {
        super(activeObjectsUtilities);
        this.planPersistence = planPersistence;
    }

    public List<IPlan> getAllPlans(final boolean includeReplanning) throws SQLException {
        return this.sql(new IQuery<List<IPlan>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                PlanSQL.this.setupPlanQuery(generator);
                generator.orderBy().colId("p");
            }

            @Override
            public List<IPlan> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(PlanSQL.this.readPlanFromResult(result, includeReplanning));
                }
                return retVal;
            }
        });
    }

    public IPlan getPlan(final String planId, final boolean includeReplanning) throws SQLException {
        return this.sql(new IQuery<IPlan>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                PlanSQL.this.setupPlanQuery(generator).where().colId("p").eq().numeric(planId).orderBy().colId("p");
            }

            @Override
            public IPlan handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return PlanSQL.this.readPlanFromResult(result, includeReplanning);
                }
                return null;
            }
        });
    }

    public EntityInfo getEntityInfo(final String planId) throws SQLException {
        return this.sql(new IQuery<EntityInfo>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPlan.class, "p").select().col("p", "version").colCoalesce("p", "planVersion", "0").colCoalesce("p", "schedulingVersion", "0").from("p").where().colId("p").eq().numeric(planId);
            }

            @Override
            public EntityInfo handleResult(ResultSet set) throws Exception {
                if (set.next()) {
                    return new EntityInfo.Impl(planId, PlanSQL.getLong(set, 1), planId, PlanSQL.getLong(set, 2), PlanSQL.getLong(set, 3));
                }
                return null;
            }
        });
    }

    public void incrementPlanVersion(final String planId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator query) throws Exception {
                query.withTable(AOPlan.class, "p").update().tableNoAlias("p").set().colNoAlias("p", "planVersion").eq().raw("(coalesce(").colNoAlias("p", "planVersion").raw(",0) + 1)").where().colIdNoAlias("p").eq().numeric(planId);
            }
        });
    }

    public void incrementVersions(Connection connection, final String planId, final boolean incrementPlanVersion, final boolean incrementSchedulingVersion) throws SQLException {
        if (!incrementPlanVersion && !incrementSchedulingVersion) {
            throw new IllegalArgumentException("Increment either plan version or scheduling version, or both.");
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator query) throws Exception {
                query.withTable(AOPlan.class, "p").update().tableNoAlias("p").set();
                if (incrementPlanVersion) {
                    query.colNoAlias("p", "planVersion").eq().raw("(coalesce(").colNoAlias("p", "planVersion").raw(",0) + 1)");
                    if (incrementSchedulingVersion) {
                        query.raw(",");
                    }
                }
                if (incrementSchedulingVersion) {
                    query.colNoAlias("p", "schedulingVersion").eq().raw("(coalesce(").colNoAlias("p", "schedulingVersion").raw(",0) + 1)");
                }
                query.where().colIdNoAlias("p").eq().numeric(planId);
            }
        }, connection, false);
    }

    private AOQueryGenerator setupPlanQuery(AOQueryGenerator generator) throws SQLException {
        generator.withTable(AOPlan.class, "p").select().colId("p").col("p", "title").col("p", "details").col("p", "version").colCoalesce("p", "planVersion", "0").colCoalesce("p", "schedulingVersion", "0").col("p", "aodate").col("p", "aoReplanningDate").col("p", "replanningVersion").raw(", COALESCE(").col("p", "inReplanning").raw(", ").bool(false).raw(")").raw(", COALESCE(").col("p", "inStreamMode").raw(", ").bool(false).raw(")").from("p");
        return generator;
    }

    private RestPlan readPlanFromResult(ResultSet result, boolean includeReplanning) throws SQLException {
        RestPlan plan = new RestPlan(PlanSQL.getString(result, 1), PlanSQL.getString(result, 2), PlanSQL.getString(result, 3));
        plan.setVersion(PlanSQL.getLong(result, 4));
        plan.setPlanVersion(PlanSQL.getLong(result, 5));
        plan.setSchedulingVersion(PlanSQL.getLong(result, 6));
        plan.setDate(PlanSQL.getLong(result, 7));
        if (includeReplanning) {
            plan.setReplanningDate(PlanSQL.getLong(result, 8));
            plan.setReplanningVersion(PlanSQL.getLong(result, 9));
            plan.setInReplanning(PlanSQL.getBoolean(result, 10));
        }
        plan.setInStreamMode(PlanSQL.getBoolean(result, 11));
        IPlanConfiguration config = this.planPersistence.getPlanConfiguration(plan.getId());
        plan.setTemplateType(config.getTemplateType());
        return plan;
    }

    public void setReleaseMode(final String planId, final boolean inReleaseMode) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPlan.class, "p").update().tableNoAlias("p").set().colNoAlias("p", "inStreamMode").eq().bool(inReleaseMode).where().colIdNoAlias("p").eq().numeric(planId);
            }
        });
    }

    public List<String> listAllAvailablePlanIds() throws SQLException {
        return this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPlan.class, "p").select().colId("p").from("p");
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList ids = Lists.newArrayList();
                while (result.next()) {
                    ids.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return ids;
            }
        });
    }

    public Map<String, IPlan> listPlansWithPermission(final UserData activeUserData) throws Exception {
        final ArrayList holderIds = Lists.newArrayList(activeUserData.getGroupIDs());
        holderIds.add(activeUserData.getUserID());
        return this.sql(new IQuery<Map<String, IPlan>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOPermission.class, "pe").withTable(AOPermission.class, "sys_pe").withTable(AOPlan.class, "pl").select().distinct().colId("pl").col("pl", "title").col("pl", "description").from("sys_pe").raw(",(").withTable(AOPlan.class, "p").select().colIdAsString("p").col("p", "title").col("p", "description").from("p").raw(") pl").leftJoin().table("pe").on().colId("pl").eq().col("pe", "targetId").and().col("pe", "targetType").eq().str("plan").where().in(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col("pe", "holderId");
                    }
                }, holderIds).or().col("pe", "targetId").isNull().and().col("sys_pe", "targetType").eq().str("system").and().in(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col("sys_pe", "holderId");
                    }
                }, activeUserData.getGroupIDs());
            }

            @Override
            public Map<String, IPlan> handleResult(ResultSet result) throws Exception {
                HashMap planMap = Maps.newHashMap();
                while (result.next()) {
                    String id = BaseAOPersistenceSQL.getString(result, 1);
                    String title = BaseAOPersistenceSQL.getString(result, 2);
                    String description = BaseAOPersistenceSQL.getString(result, 3);
                    RestPlan plan = new RestPlan(id, title, description);
                    planMap.put(id, plan);
                }
                return planMap;
            }
        });
    }
}

