/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.themes;

import com.radiantminds.roadmap.common.data.entities.common.IPercentable;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.utils.IPercentableCallback;
import com.radiantminds.roadmap.common.rest.utils.PercentageUtils;
import javax.ws.rs.core.Response;

public interface ThemeServiceHandler {
    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response entryDelete(EntityContext<ITheme> var1) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Off, incrementEntityVersion=VersionIncrementMode.Off)
    public Response setPercentage(EntityContext<ITheme> var1, Double var2) throws Exception;

    public static class Impl
    implements ThemeServiceHandler {
        private final PortfolioThemePersistence themePersistence;
        private final PortfolioPlanPersistence planPersistence;

        public Impl(PortfolioThemePersistence themePersistence, PortfolioPlanPersistence planPersistence) {
            this.themePersistence = themePersistence;
            this.planPersistence = planPersistence;
        }

        @Override
        public Response entryDelete(EntityContext<ITheme> entityContext) throws Exception {
            this.themePersistence.delete(entityContext.getEntityId(), false);
            PercentageUtils.adaptToItemRemoval(this.planPersistence.get(entityContext.getEntityInfo().getPlanId()), IPercentableCallback.THEME, this.themePersistence);
            return entityContext.ok();
        }

        @Override
        public Response setPercentage(EntityContext<ITheme> entityContext, Double value) throws Exception {
            ModificationResult retVal = PercentageUtils.setPercentage((IPercentable)entityContext.getEntity(), value, IPercentableCallback.THEME, this.themePersistence);
            return entityContext.ok(retVal);
        }
    }
}

