/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.customfields.service;

import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.api.customfields.service.IssueTypeProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CustomFieldMetadata {
    private final String fieldName;
    private final String fieldDescription;
    private final String fieldType;
    private final String fieldSearcher;
    private final Option<IssueTypeProvider> issueTypeProvider;
    private final List<String> optionNames;
    private final String defaultOptionName;
    private final boolean lockField;
    private final String lockFieldDescription;
    private final boolean requireField;

    public CustomFieldMetadata(String fieldName, String fieldDescription, String fieldType, String fieldSearcher, Option<IssueTypeProvider> issueTypeProvider, List<String> optionNames, String defaultOptionName, boolean lockField, String lockFieldDescription, boolean requireField) {
        this.fieldName = fieldName;
        this.fieldDescription = fieldDescription;
        this.fieldType = fieldType;
        this.fieldSearcher = fieldSearcher;
        this.issueTypeProvider = issueTypeProvider;
        this.optionNames = optionNames;
        this.defaultOptionName = defaultOptionName;
        this.lockField = lockField;
        this.lockFieldDescription = lockFieldDescription;
        this.requireField = requireField;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldDescription() {
        return this.fieldDescription;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFieldSearcher() {
        return this.fieldSearcher;
    }

    public Option<IssueTypeProvider> getIssueTypeProvider() {
        return this.issueTypeProvider;
    }

    public List<String> getOptionNames() {
        return this.optionNames;
    }

    public String getDefaultOptionName() {
        return this.defaultOptionName;
    }

    public boolean isLockField() {
        return this.lockField;
    }

    public String getLockFieldDescription() {
        return this.lockFieldDescription;
    }

    public boolean isRequireField() {
        return this.requireField;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("fieldName", (Object)this.fieldName).append("fieldDescription", (Object)this.fieldDescription).append("fieldType", (Object)this.fieldType).append("fieldSearcher", (Object)this.fieldSearcher).append("optionNames", this.optionNames).append("defaultOptionName", (Object)this.defaultOptionName).append("lockField", this.lockField).append("lockFieldDescription", (Object)this.lockFieldDescription).append("requireField", this.requireField).toString();
    }

    public static class Builder {
        private String fieldName;
        private String fieldDescription;
        private String fieldType;
        private String fieldSearcher;
        private Option<IssueTypeProvider> issueTypeProvider = Option.none();
        private Set<String> issueTypes = new HashSet<String>();
        private List<String> optionNames = new ArrayList<String>();
        private String defaultOptionName;
        private boolean lockField;
        private String lockFieldDescription;
        private boolean requireField;

        public Builder() {
        }

        public Builder(String fieldName, String fieldDescription, String fieldType, String fieldSearcher, Option<IssueTypeProvider> issueTypeProvider, Set<String> issueTypes, List<String> optionNames, String defaultOptionName, boolean lockField, String lockFieldDescription, boolean requireField) {
            this.fieldName = fieldName;
            this.fieldDescription = fieldDescription;
            this.fieldType = fieldType;
            this.fieldSearcher = fieldSearcher;
            this.issueTypeProvider = issueTypeProvider;
            this.issueTypes = issueTypes;
            this.optionNames = optionNames;
            this.defaultOptionName = defaultOptionName;
            this.lockField = lockField;
            this.lockFieldDescription = lockFieldDescription;
            this.requireField = requireField;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder fieldDescription(String fieldDescription) {
            this.fieldDescription = fieldDescription;
            return this;
        }

        public Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder fieldSearcher(String fieldSearcher) {
            this.fieldSearcher = fieldSearcher;
            return this;
        }

        public Builder issueTypeProvider(IssueTypeProvider issueTypeProvider) {
            this.issueTypeProvider = issueTypeProvider != null ? Option.option((Object)issueTypeProvider) : Option.none();
            return this;
        }

        public Builder issueTypes(String ... issueTypes) {
            this.issueTypes.clear();
            this.issueTypes.addAll(Arrays.asList(issueTypes));
            return this;
        }

        public Builder issueTypes(Set<String> issueTypes) {
            this.issueTypes.clear();
            this.issueTypes.addAll(issueTypes);
            return this;
        }

        public Builder optionNames(String ... optionNames) {
            this.optionNames.clear();
            this.optionNames.addAll(Arrays.asList(optionNames));
            return this;
        }

        public Builder optionNames(String defaultOptionName) {
            if (this.optionNames.contains(defaultOptionName)) {
                this.defaultOptionName = defaultOptionName;
            }
            return this;
        }

        public Builder lockField(boolean lockField) {
            this.lockField = lockField;
            return this;
        }

        public Builder lockFieldDescription(String lockFieldDescription) {
            this.lockFieldDescription = lockFieldDescription;
            return this;
        }

        public Builder requireField(boolean requireField) {
            this.requireField = requireField;
            return this;
        }

        public CustomFieldMetadata build() {
            return new CustomFieldMetadata(this.fieldName, this.fieldDescription, this.fieldType, this.fieldSearcher, this.issueTypeProvider, this.optionNames, this.defaultOptionName, this.lockField, this.lockFieldDescription, this.requireField);
        }
    }
}

