/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.labels;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.label.LabelService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.labels.IssueLabelServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.labels.IssueLabelServiceException;
import com.google.common.base.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.labels.IssueLabelServiceBridgeImpl")
@SupportedVersions(all=true)
class IssueLabelServiceBridgeImpl
implements IssueLabelServiceBridge {
    private static final String CANNOT_SET_LABELS_KEY = "label.service.error.issue.doesnt.exist";
    private final LabelService labelService;
    private final IssueService issueService;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    IssueLabelServiceBridgeImpl(LabelService labelService, IssueService issueService, I18nHelper.BeanFactory i18nFactory) {
        this.labelService = labelService;
        this.issueService = issueService;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public void setLabels(ApplicationUser user, long issueId, Set<String> labels) throws IssueLabelServiceException {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, Long.valueOf(issueId));
        if (!issueResult.isValid()) {
            throw new IssueLabelServiceException(issueResult.getErrorCollection());
        }
        if (issueResult.getIssue().isArchived()) {
            I18nHelper i18n = this.getI18n(user);
            String errorMessage = i18n.getText(CANNOT_SET_LABELS_KEY, (Object)issueId);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(errorMessage);
            throw new IssueLabelServiceException((ErrorCollection)errors);
        }
        LabelService.SetLabelValidationResult setLabelValidationResult = this.labelService.validateSetLabels(user, Long.valueOf(issueId), labels);
        if (!setLabelValidationResult.isValid()) {
            throw new IssueLabelServiceException(setLabelValidationResult.getErrorCollection());
        }
        this.labelService.setLabels(user, setLabelValidationResult, true, true);
    }

    @Override
    public Set<String> getSuggestedLabels(ApplicationUser user, Optional<Long> issueId, Optional<String> searchString) throws IssueLabelServiceException {
        LabelService.LabelSuggestionResult suggestedLabels = this.labelService.getSuggestedLabels(user, (Long)issueId.orNull(), (String)searchString.orNull());
        return this.validateResult(suggestedLabels);
    }

    @Override
    public Set<String> getSuggestedLabelsForCustomField(ApplicationUser user, Long customFieldId, Optional<String> searchString) throws IssueLabelServiceException {
        LabelService.LabelSuggestionResult suggestedLabels = this.labelService.getSuggestedLabels(user, null, customFieldId, (String)searchString.orNull());
        return this.validateResult(suggestedLabels);
    }

    private Set<String> validateResult(LabelService.LabelSuggestionResult result) throws IssueLabelServiceException {
        if (!result.isValid()) {
            throw new IssueLabelServiceException(result.getErrorCollection());
        }
        return result.getSuggestions();
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

