/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.DefaultOverbookedActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.DistributedOverbookedActivityAssignmentProblemVariables;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.IndexedOverbookableResourceSkillVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentProblemVariables;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedActivityAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.OverbookedWorkDistributionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpLogging;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.ApacheUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class OverbookedActivityAssignmentSolverApacheImpl
implements OverbookedActivityAssignmentSolver {
    private static final Log LOGGER = Log.with(OverbookedActivityAssignmentSolverApacheImpl.class);
    private static final int MAX_RESOURCES_FOR_DISTRIBUTION = 40;
    private static final double DEFAULT_EPSILON = 0.001;
    private static final int DEFAULT_ULPS = 10;
    private static final double DEFAULT_CUT_OFF = 1.0E-7;
    private final SimplexSolver simplexSolver = new SimplexSolver(0.001, 10, 1.0E-7);
    private final int maxResourcesForDistribution;

    public OverbookedActivityAssignmentSolverApacheImpl() {
        this(40);
    }

    OverbookedActivityAssignmentSolverApacheImpl(int maxResourcesForDistribution) {
        this.maxResourcesForDistribution = maxResourcesForDistribution;
    }

    @Override
    public Optional<OverbookedActivityAssignmentSolution> solve(ActivityAssignmentProblem problem) {
        LOGGER.debug("try to solve problem: %s", problem);
        if (problem.getResources() <= this.maxResourcesForDistribution) {
            return this.solveWithDistributedOverbooking(problem);
        }
        return this.solveWithoutDistributedOverbooking(problem);
    }

    private Optional<OverbookedActivityAssignmentSolution> solveWithoutDistributedOverbooking(ActivityAssignmentProblem problem) {
        try {
            LOGGER.debug("solve without overbooked work distribution", new Object[0]);
            OverbookedActivityAssignmentProblemVariables variables = OverbookedActivityAssignmentProblemVariables.create(problem);
            OptimizationData[] optData = this.transformToOverbooked(variables);
            LpLogging.logDebug(optData);
            PointValuePair simplexSolution = this.simplexSolver.optimize(optData);
            DefaultOverbookedActivityAssignmentSolution solution = DefaultOverbookedActivityAssignmentSolution.create(RmUtils.toFloatArray(simplexSolution.getPoint()), ((Double)simplexSolution.getValue()).floatValue(), variables);
            LOGGER.debug("found solution: %s", solution);
            return Optional.of((Object)solution);
        }
        catch (NoFeasibleSolutionException e) {
            LOGGER.debug("no feasible solution found", new Object[0]);
            return Optional.absent();
        }
    }

    private OptimizationData[] transformToOverbooked(OverbookedActivityAssignmentProblemVariables variables) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MINIMIZE);
        optData.add(this.createObjectiveFunction(variables));
        optData.add(this.createLinearConstraints(variables));
        optData.add(new NonNegativeConstraint(true));
        return optData.toArray(new OptimizationData[optData.size()]);
    }

    private OptimizationData createLinearConstraints(OverbookedActivityAssignmentProblemVariables variables) {
        ArrayList constraints = Lists.newArrayList();
        constraints.addAll(OverbookedActivityAssignmentSolverApacheImpl.createAvailabilityConstraintSet(variables));
        constraints.addAll(OverbookedActivityAssignmentSolverApacheImpl.createStrictOpenSkillConstraintSet(variables));
        return new LinearConstraintSet(constraints);
    }

    private static List<LinearConstraint> createStrictOpenSkillConstraintSet(OverbookedActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        for (int s = 0; s < problem.getSkills(); ++s) {
            constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(problem.getSkillVariables(s), problem.getVariableCount()), Relationship.EQ, problem.getDemand(s)));
        }
        return constraints;
    }

    private static List<LinearConstraint> createAvailabilityConstraintSet(OverbookedActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        for (int r = 0; r < problem.getResources(); ++r) {
            constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(problem.getResourceVariables(r), problem.getVariableCount()), Relationship.LEQ, problem.getAvailability(r)));
        }
        return constraints;
    }

    private OptimizationData createObjectiveFunction(OverbookedActivityAssignmentProblemVariables variables) {
        return new LinearObjectiveFunction(ApacheUtils.createSetCoefficients(variables.getOverbookWorkVariables(), variables.getVariableCount()), 0.0);
    }

    private Optional<OverbookedActivityAssignmentSolution> solveWithDistributedOverbooking(ActivityAssignmentProblem problem) {
        try {
            LOGGER.debug("solve with overbooked work distribution", new Object[0]);
            DistributedOverbookedActivityAssignmentProblemVariables variables = DistributedOverbookedActivityAssignmentProblemVariables.create(problem);
            OptimizationData[] optData = this.transformToOverbooked(variables);
            LpLogging.logDebug(optData);
            PointValuePair simplexSolution = this.simplexSolver.optimize(optData);
            DefaultOverbookedActivityAssignmentSolution solution = DefaultOverbookedActivityAssignmentSolution.create(RmUtils.toFloatArray(simplexSolution.getPoint()), variables);
            LOGGER.debug("found solution> %s", solution);
            return Optional.of((Object)solution);
        }
        catch (NoFeasibleSolutionException e) {
            LOGGER.debug("no feasible solution found", new Object[0]);
            return Optional.absent();
        }
    }

    private OptimizationData[] transformToOverbooked(DistributedOverbookedActivityAssignmentProblemVariables variables) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MINIMIZE);
        optData.add(OverbookedActivityAssignmentSolverApacheImpl.createObjectiveFunction(variables));
        optData.add(this.createLinearConstraints(variables));
        optData.add(new NonNegativeConstraint(true));
        return optData.toArray(new OptimizationData[optData.size()]);
    }

    private OptimizationData createLinearConstraints(DistributedOverbookedActivityAssignmentProblemVariables variables) {
        ArrayList constraints = Lists.newArrayList();
        constraints.addAll(OverbookedActivityAssignmentSolverApacheImpl.createAvailabilityConstraintSet(variables));
        constraints.addAll(OverbookedActivityAssignmentSolverApacheImpl.createStrictOpenSkillConstraintSet(variables));
        constraints.addAll(OverbookedActivityAssignmentSolverApacheImpl.createDistributionConstraints(variables));
        return new LinearConstraintSet(constraints);
    }

    private static List<LinearConstraint> createStrictOpenSkillConstraintSet(DistributedOverbookedActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        for (int s = 0; s < problem.getSkills(); ++s) {
            constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(problem.getSkillVariables(s), problem.getVariableCount()), Relationship.EQ, problem.getDemand(s)));
        }
        return constraints;
    }

    private static List<LinearConstraint> createAvailabilityConstraintSet(DistributedOverbookedActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        for (int r = 0; r < problem.getResources(); ++r) {
            constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(problem.getResourceVariables(r), problem.getVariableCount()), Relationship.LEQ, problem.getAvailability(r)));
        }
        return constraints;
    }

    private static List<LinearConstraint> createDistributionConstraints(DistributedOverbookedActivityAssignmentProblemVariables problem) {
        ArrayList constraints = Lists.newArrayList();
        double[] coefficients = new double[problem.getVariableCount()];
        for (int r1 = 0; r1 < problem.getResources() - 1; ++r1) {
            for (int r2 = r1 + 1; r2 < problem.getResources(); ++r2) {
                List<OverbookedWorkDistributionVariable> distributionVariables = problem.getOverbookDistributionVariables(r1, r2);
                coefficients[distributionVariables.get((int)0).getIndex()] = 1.0;
                for (IndexedOverbookableResourceSkillVariable variable : problem.getOverbookWorkVariables(r1)) {
                    coefficients[variable.getIndex()] = 1.0;
                }
                coefficients[distributionVariables.get((int)1).getIndex()] = -1.0;
                for (IndexedOverbookableResourceSkillVariable variable : problem.getOverbookWorkVariables(r2)) {
                    coefficients[variable.getIndex()] = -1.0;
                }
                constraints.add(new LinearConstraint(coefficients, Relationship.EQ, 0.0));
            }
        }
        return constraints;
    }

    private static OptimizationData createObjectiveFunction(DistributedOverbookedActivityAssignmentProblemVariables problem) {
        double[] coefficients = new double[problem.getVariableCount()];
        double validWorkCoefficient = IntMath.binomial((int)(problem.getResources() + 1), (int)2);
        for (IndexedOverbookableResourceSkillVariable indexedOverbookableResourceSkillVariable : problem.getNonOverbookWorkVariables()) {
            coefficients[indexedOverbookableResourceSkillVariable.getIndex()] = -validWorkCoefficient;
        }
        for (OverbookedWorkDistributionVariable overbookedWorkDistributionVariable : problem.getOverbookDistributionVariables()) {
            coefficients[overbookedWorkDistributionVariable.getIndex()] = 1.0;
        }
        LinearObjectiveFunction objective = new LinearObjectiveFunction(coefficients, 0.0);
        return objective;
    }
}

