/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ResourceSkillVariable;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class ActivityAssignmentSubProblem
implements ActivityAssignmentProblem {
    private final int activity;
    private final List<Integer> resources;
    private final List<Float> availabilities;
    private final float[][] activityDemands;
    private final List<ResourceSkillVariable> variables;

    public ActivityAssignmentSubProblem(int activity, List<Integer> resources, List<Float> availabilities, boolean[][] resourceSkills, float[][] activityDemands) {
        this.activity = activity;
        this.resources = resources;
        this.availabilities = availabilities;
        this.activityDemands = activityDemands;
        this.variables = ActivityAssignmentSubProblem.initVariables(activity, resources, resourceSkills, activityDemands);
    }

    private static List<ResourceSkillVariable> initVariables(int activity, List<Integer> resources, boolean[][] resourceToSkills, float[][] demands) {
        ArrayList sortedVariables = Lists.newArrayListWithCapacity((int)(resources.size() * demands.length));
        for (int r = 0; r < resources.size(); ++r) {
            for (int s = 0; s < demands[0].length; ++s) {
                if (demands[activity][s] <= 0.0f || !resourceToSkills[resources.get(r)][s]) continue;
                sortedVariables.add(new ResourceSkillVariable(r, s));
            }
        }
        return sortedVariables;
    }

    @Override
    public List<ResourceSkillVariable> getVariables() {
        return this.variables;
    }

    @Override
    public int getSkills() {
        return this.activityDemands[0].length;
    }

    @Override
    public float getDemand(int skill) {
        return this.activityDemands[this.activity][skill];
    }

    @Override
    public float getAvailability(int resource) {
        return this.availabilities.get(resource).floatValue();
    }

    @Override
    public float getUpperBound(int resource, int skill) {
        return Math.min(this.getAvailability(resource), this.getDemand(skill));
    }

    @Override
    public int getResources() {
        return this.resources.size();
    }

    @Override
    public int getVariableCount() {
        return this.variables.size();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("activity", this.activity).add("resources", this.resources).add("availabilities", this.availabilities).add("activityDemands", (Object)this.activityDemands).add("variables", this.variables).toString();
    }
}

