/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IPartialUnstructuredItemStageProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.IUnstructuredStageSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.MultiSlotAssignmentCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.SingleSlotAssignmentCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class UnstructuredStageScheduler
implements IUnstructuredStageSolver {
    private static final Log LOGGER = Log.with(UnstructuredStageScheduler.class);
    private final SingleSlotAssignmentCreator singleSlotAssignmentCreator;
    private final MultiSlotAssignmentCreator multiSlotAssignmentCreator;

    UnstructuredStageScheduler(SingleSlotAssignmentCreator singleSlotAssignmentCreator, MultiSlotAssignmentCreator multiSlotAssignmentCreator) {
        this.singleSlotAssignmentCreator = singleSlotAssignmentCreator;
        this.multiSlotAssignmentCreator = multiSlotAssignmentCreator;
    }

    public UnstructuredStageScheduler(CancellationState cancellationState) {
        this(new SingleSlotAssignmentCreator(cancellationState), new MultiSlotAssignmentCreator(cancellationState));
    }

    @Override
    public Optional<IUnstructuredItemSchedule> trySolveNextStageProblemForGroup(IPartialUnstructuredItemStageProblem stageProblem, IMutableResourcePool resourcePool, IUnstructuredItemSchedule bestSoFar) throws InterruptedException {
        LogUtil.debug(LOGGER, "try create schedule for problem %s and resources: %s", stageProblem, resourcePool);
        int upperTimeBound = this.getUpperTimeBound(bestSoFar, stageProblem);
        Optional<ISingleResourceGroupAssignment> assignment = this.tryCreateAssignment(stageProblem, resourcePool, upperTimeBound);
        if (!assignment.isPresent()) {
            LogUtil.debug(LOGGER, "did not find an assignment with time bound: %s", upperTimeBound);
            return Optional.absent();
        }
        String id = stageProblem.getId();
        int releaseTime = stageProblem.getLowerTimeBound();
        HashMap assignments = Maps.newHashMap();
        assignments.put(resourcePool.getMutableResourceGroup(), assignment.get());
        Optional<IUnstructuredItemSchedule> schedule = UnstructuredItemSchedule.tryCreatePartialInstance(id, assignments, releaseTime);
        LogUtil.debug(LOGGER, "created schedule: %s", schedule);
        return schedule;
    }

    private int getUpperTimeBound(IUnstructuredItemSchedule bestSoFar, IPartialUnstructuredItemStageProblem stageProblem) {
        if (bestSoFar == null) {
            return stageProblem.getUpperTimeBound();
        }
        return bestSoFar.getEnd();
    }

    private Optional<ISingleResourceGroupAssignment> tryCreateAssignment(IPartialUnstructuredItemStageProblem stageProblem, IMutableResourcePool resourcePool, int timeBound) throws InterruptedException {
        if (resourcePool.isWorkSlotStrict()) {
            return this.singleSlotAssignmentCreator.tryCreateAssignment(stageProblem, resourcePool, timeBound);
        }
        return this.multiSlotAssignmentCreator.tryCreateAssignment(stageProblem, resourcePool, timeBound);
    }
}

