/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.PreconditionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class ResourceType
implements IResourceType {
    public static final String DUMMY_ID = "dummyType";
    public static final IResourceType DUMMY_TYPE = new ResourceType("dummyType", 1.0f, "default", null, true, "");
    private final String id;
    private final float percentage;
    private final String title;
    private final String stageId;
    private final Boolean generated;
    private final String sortOrder;

    public ResourceType(String id, float percentage, String stageId, String title, Boolean generated, String sortKey) {
        Preconditions.checkNotNull((Object)id, (Object)"ID must not be null");
        Preconditions.checkNotNull((Object)stageId, (Object)"stage ID must not be null");
        Preconditions.checkNotNull((Object)sortKey, (Object)"sort key must not be null");
        PreconditionUtils.checkArgumentRealPercentage(percentage);
        this.id = id;
        this.percentage = percentage;
        this.stageId = stageId;
        this.title = title;
        this.generated = generated;
        this.sortOrder = sortKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public float getPercentageWithinProcessingStage() {
        return this.percentage;
    }

    @Override
    public Optional<Boolean> isGenerated() {
        return Optional.fromNullable((Object)this.generated);
    }

    @Override
    public String getStageId() {
        return this.stageId;
    }

    @Override
    public String getSortKey() {
        return this.sortOrder;
    }

    public String toString() {
        return "ResourceType [id=" + this.id + ", title=" + this.title + "]";
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.id).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceType)) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return new EqualsBuilder().append(this.id, other.id).isEquals();
    }
}

