/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.backlog;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.backlog.EstimatePersistency;
import com.radiantminds.roadmap.common.data.generator.backlog.IEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEstimateConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IStoryConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IWorkItemConfiguration;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkItemPersistency {
    private final PortfolioWorkItemPersistence persistency;
    private final EstimatePersistency estimatePersistency;

    public WorkItemPersistency(ActiveObjectsUtilities activeObjectsUtilities, PortfolioWorkItemPersistence workItemPersistence) {
        this(workItemPersistence, new EstimatePersistency(activeObjectsUtilities));
    }

    WorkItemPersistency(PortfolioWorkItemPersistence persistency, EstimatePersistency estimatePersistency) {
        this.persistency = persistency;
        this.estimatePersistency = estimatePersistency;
    }

    public Map<String, String> persistEpic(IEpicConfiguration epicConfiguration, IPlan plan) throws Exception {
        HashMap idToTitleMap = Maps.newHashMap();
        if (epicConfiguration.getStoryConfigurations().isEmpty()) {
            String id = this.persistUnstructuredEpic(epicConfiguration, plan);
            idToTitleMap.put(id, epicConfiguration.getTitle());
        } else {
            Map<String, String> epicIdTitleMap = this.persistStructuredEpic(epicConfiguration, plan);
            idToTitleMap.putAll(epicIdTitleMap);
        }
        return idToTitleMap;
    }

    private Map<String, String> persistStructuredEpic(IEpicConfiguration epicConfiguration, IPlan plan) throws Exception {
        HashMap idToTitleMap = Maps.newHashMap();
        IWorkItem epic = this.createEpic(epicConfiguration, plan);
        IWorkItem persistedEpic = this.persistency.persist(epic);
        this.setStreamOfPersistedItem(plan, epicConfiguration, persistedEpic, false);
        String epicId = persistedEpic.getId();
        idToTitleMap.put(epicId, epicConfiguration.getTitle());
        List storyConfigurations = Lists.reverse(epicConfiguration.getStoryConfigurations());
        for (int i = 0; i < storyConfigurations.size(); ++i) {
            Optional<String> teamTitle;
            IStoryConfiguration storyConfiguration = (IStoryConfiguration)storyConfigurations.get(i);
            IWorkItem story = this.persistStory(storyConfiguration, persistedEpic, plan);
            Optional<String> releaseTitle = storyConfiguration.getReleaseTitle();
            if (releaseTitle.isPresent()) {
                IRelease release = (IRelease)GeneratorUtils.tryFindWithTitle((String)releaseTitle.get(), GeneratorUtils.getReleases(plan.getStreams())).get();
                this.persistency.setRelease(story.getId(), release.getId());
            }
            if ((teamTitle = storyConfiguration.getTeamTitle()).isPresent()) {
                ITeam team = (ITeam)GeneratorUtils.tryFindWithTitle((String)teamTitle.get(), plan.getTeams()).get();
                this.persistency.setTeam(story.getId(), team.getId());
            }
            idToTitleMap.put(story.getId(), storyConfiguration.getTitle());
        }
        return idToTitleMap;
    }

    private void setStreamOfPersistedItem(IPlan plan, IWorkItemConfiguration itemConfiguration, IWorkItem workItem, boolean setDefaultStreamIfNotSpecified) throws SQLException {
        Optional<String> streamTitle = itemConfiguration.getStreamTitle();
        List<IStream> streams = plan.getStreams();
        if (streamTitle.isPresent()) {
            IStream stream = (IStream)GeneratorUtils.tryFindWithTitle((String)streamTitle.get(), streams).get();
            this.persistency.setStream(workItem.getId(), stream.getId());
        } else if (setDefaultStreamIfNotSpecified) {
            this.persistency.setStream(workItem.getId(), streams.get(0).getId());
        }
    }

    private IWorkItem persistStory(IStoryConfiguration configuration, IWorkItem epic, IPlan plan) throws Exception {
        String title = configuration.getTitle();
        RestWorkItem story = new RestWorkItem(null, title, null);
        story.setParent(epic);
        story.setPlan(plan);
        story.setType(WorkItems.Types.STORY);
        story.setEarliestStart((Long)configuration.getEarliestStart().orNull());
        IWorkItem persistedStory = this.persistency.persist(story);
        this.setStreamOfPersistedItem(plan, configuration, persistedStory, true);
        Set<IEstimateConfiguration> estimateConfigurations = configuration.getEstimateConfigurations();
        for (IEstimateConfiguration estimateConfiguration : estimateConfigurations) {
            this.estimatePersistency.persistEstimate(estimateConfiguration, persistedStory, plan);
        }
        return persistedStory;
    }

    private String persistUnstructuredEpic(IEpicConfiguration epicConfiguration, IPlan plan) throws Exception {
        Optional<String> teamTitle;
        IWorkItem item = this.createEpic(epicConfiguration, plan);
        IWorkItem persistedItem = this.persistency.persist(item);
        Optional<String> releaseTitle = epicConfiguration.getReleaseTitle();
        if (releaseTitle.isPresent()) {
            IRelease release = (IRelease)GeneratorUtils.tryFindWithTitle((String)releaseTitle.get(), GeneratorUtils.getReleases(plan.getStreams())).get();
            this.persistency.setRelease(persistedItem.getId(), release.getId());
        }
        if ((teamTitle = epicConfiguration.getTeamTitle()).isPresent()) {
            ITeam team = (ITeam)GeneratorUtils.tryFindWithTitle((String)teamTitle.get(), plan.getTeams()).get();
            this.persistency.setTeam(persistedItem.getId(), team.getId());
        }
        this.setStreamOfPersistedItem(plan, epicConfiguration, persistedItem, true);
        Set<IEstimateConfiguration> estimateConfigurations = epicConfiguration.getEstimateConfigurations();
        for (IEstimateConfiguration estimateConfiguration : estimateConfigurations) {
            this.estimatePersistency.persistEstimate(estimateConfiguration, persistedItem, plan);
        }
        return persistedItem.getId();
    }

    private IWorkItem createEpic(IWorkItemConfiguration epicConfiguration, IPlan plan) throws PersistenceException {
        RestWorkItem item = new RestWorkItem(null, null, null);
        item.setPlan(plan);
        String title = epicConfiguration.getTitle();
        item.setTitle(title);
        item.setType(WorkItems.Types.EPIC);
        item.setEarliestStart((Long)epicConfiguration.getEarliestStart().orNull());
        return item;
    }
}

