/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.settings;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.generator.settings.ISkillConfiguration;

public class SkillConfiguration
implements ISkillConfiguration {
    private final String title;
    private final Double percentage;

    SkillConfiguration(String title, Double percentage) {
        this.title = title;
        this.percentage = percentage;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Optional<Double> getPercentage() {
        return Optional.fromNullable((Object)this.percentage);
    }

    public static class Builder {
        private final String title;
        private Double percentage;

        public Builder(String title) {
            this.title = title;
        }

        public Builder withPercentage(Double percentage) {
            this.percentage = percentage;
            return this;
        }

        public SkillConfiguration build() {
            return new SkillConfiguration(this.title, this.percentage);
        }
    }
}

